/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.jcraft.jsch.JSchException;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.ProtocolFulfillmentException;
import com.mathworks.toolbox.distcomp.remote.ReverseTunnelCommand;
import com.mathworks.toolbox.distcomp.remote.TunnelFuture;
import com.mathworks.toolbox.distcomp.remote.spi.LeaseMonitor;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchLeasableSession;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSessionLeaseSource;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public final class JSchReverseTunnelFuture
implements TunnelFuture,
Runnable {
    private final Lock fLock = new ReentrantLock();
    private final Condition fCompleted = this.fLock.newCondition();
    private boolean fHasCompleted = false;
    private boolean fHasBeenCancelled = false;
    private FulfillmentException fCauseOfProblem = null;
    private final String fLogIDString;
    private final ReverseTunnelCommand fCommand;
    private final LeaseMonitor<JSchLeasableSession> fSessionMonitor;
    private final int fLocalPort;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JSchReverseTunnelFuture createJSchReverseTunnelFuture(ReverseTunnelCommand reverseTunnelCommand, String string, ParameterMap parameterMap) throws DispatchException {
        String string2 = string + " " + reverseTunnelCommand + ":";
        boolean bl = false;
        LeaseMonitor<JSchLeasableSession> leaseMonitor = null;
        try {
            leaseMonitor = JSchSessionLeaseSource.createForTunnelFuture(string, parameterMap);
            JSchReverseTunnelFuture jSchReverseTunnelFuture = new JSchReverseTunnelFuture(reverseTunnelCommand, leaseMonitor, parameterMap, string2);
            JSchReverseTunnelFuture.startThread(jSchReverseTunnelFuture, string2);
            bl = true;
            Logger.LOGGER.fine(string2 + ": started");
            JSchReverseTunnelFuture jSchReverseTunnelFuture2 = jSchReverseTunnelFuture;
            return jSchReverseTunnelFuture2;
        }
        finally {
            if (!bl && leaseMonitor != null) {
                leaseMonitor.disconnectWithNoRelease();
            }
        }
    }

    private JSchReverseTunnelFuture(ReverseTunnelCommand reverseTunnelCommand, LeaseMonitor<JSchLeasableSession> leaseMonitor, ParameterMap parameterMap, String string) throws ProtocolDispatchException {
        this.fCommand = reverseTunnelCommand;
        this.fSessionMonitor = leaseMonitor;
        this.fLogIDString = string;
        this.fLocalPort = reverseTunnelCommand.getLocalHostPort();
        String string2 = reverseTunnelCommand.getLocalHostBindAddress();
        String string3 = reverseTunnelCommand.getRemoteHostBindAddress();
        int n = reverseTunnelCommand.getRemoteHostPort();
        Logger.LOGGER.fine(this.fLogIDString + ": about to set port forwarding");
        try {
            this.fSessionMonitor.getLeasedConnection().getSession().setPortForwardingR(string3, n, string2, this.fLocalPort);
        }
        catch (JSchException jSchException) {
            throw new ProtocolDispatchException(jSchException);
        }
        Logger.LOGGER.fine(this.fLogIDString + ": connected");
    }

    private static void startThread(JSchReverseTunnelFuture jSchReverseTunnelFuture, String string) {
        Thread thread = new Thread((Runnable)jSchReverseTunnelFuture, string);
        thread.start();
        Logger.LOGGER.finest(string + ": thread started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.fLock.lock();
        try {
            this.fHasBeenCancelled = true;
            this.fHasCompleted = false;
            this.fCompleted.signalAll();
            Logger.LOGGER.fine(this.fLogIDString + ": cancelled");
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        this.fLock.lock();
        try {
            boolean bl = !this.fHasCompleted;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitEnd() throws InterruptedException, FulfillmentException {
        this.fLock.lockInterruptibly();
        try {
            if (!this.fHasCompleted) {
                Logger.LOGGER.finest(this.fLogIDString + ": awaitEnd await started");
                this.fCompleted.await();
                Logger.LOGGER.finest(this.fLogIDString + ": awaitEnd await done");
            }
            if (this.fCauseOfProblem != null) {
                throw this.fCauseOfProblem;
            }
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                try {
                    if (!this.hasBeenCancelled()) {
                        this.maintainTunnel();
                    }
                }
                finally {
                    this.closeTunnel();
                }
            }
            finally {
                this.fSessionMonitor.disconnectWithNoRelease();
            }
        }
        finally {
            this.fLock.lock();
            try {
                this.fHasCompleted = true;
                this.fCompleted.signalAll();
            }
            finally {
                this.fLock.unlock();
            }
        }
    }

    private void closeTunnel() {
        try {
            this.fSessionMonitor.getLeasedConnection().getSession().delPortForwardingR(this.fLocalPort);
        }
        catch (JSchException jSchException) {
            this.handleException((Exception)((Object)jSchException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasBeenCancelled() {
        this.fLock.lock();
        try {
            boolean bl = this.fHasBeenCancelled;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    private void maintainTunnel() {
        Logger.LOGGER.finest(this.fLogIDString + ": maintain started");
        try {
            while (!this.hasBeenCancelled() && this.fSessionMonitor.isConnected()) {
                Thread.sleep(100L);
            }
            Logger.LOGGER.finest(this.fLogIDString + ": maintain complete");
        }
        catch (InterruptedException interruptedException) {
            Logger.LOGGER.fine(this.fLogIDString + ": maintain interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Exception exception) {
        Logger.LOGGER.log(Level.WARNING, this.fLogIDString + ": ", exception);
        this.fLock.lock();
        try {
            this.fCauseOfProblem = new ProtocolFulfillmentException(exception);
        }
        finally {
            this.fLock.unlock();
        }
    }
}

