/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.CopyCommand;
import com.mathworks.toolbox.distcomp.remote.CopyFromRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.CopyToRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.Environment;
import com.mathworks.toolbox.distcomp.remote.Future;
import com.mathworks.toolbox.distcomp.remote.InvalidValueException;
import com.mathworks.toolbox.distcomp.remote.LocalProcessFailedException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterImpl;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.spi.FileCopier;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.ProcessCopyFuture;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.ShellParameter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public final class WindowsRcpCopier
implements FileCopier {
    private static final String PROTOCOL_NAME = "rcp";
    private static final String PROTOCOL_TYPE = "rcp";
    private static final ParameterSet WINDOWS_RCP_PARAMETERS = new ParameterSet(WindowsRcpParameter.USERNAME, ShellParameter.FREE_FORM_PARAMETERS, ShellParameter.LOCAL_ENVIRONMENT, WindowsRcpParameter.RCP_COMMAND, WindowsRcpParameter.BINARY_MODE, WindowsRcpParameter.HIDDEN_FILES);

    @Override
    public ParameterSet getParameterSet() {
        return WINDOWS_RCP_PARAMETERS;
    }

    @Override
    public String getProtocolName() {
        return "rcp";
    }

    @Override
    public String getProtocolType() {
        return "rcp";
    }

    @Override
    public Class<? extends Command> getCommandClass() {
        return CopyCommand.class;
    }

    private String createRemoteSpecifier(String string, String string2, Parameter<String> parameter, ParameterMap parameterMap) {
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = parameterMap.getOrSuggest(parameter);
        stringBuilder.append(string);
        stringBuilder.append(".");
        stringBuilder.append(string3);
        stringBuilder.append(":");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private String createLocalSpecifier(File file) {
        return file.toString();
    }

    @Override
    public ProcessCopyFuture copyFile(CopyCommand copyCommand, String string, ParameterMap parameterMap) throws InvalidValueException, LocalProcessFailedException, ProtocolDispatchException {
        Object object2;
        Object object3;
        if (copyCommand.anyFilesExcluded()) {
            throw new ProtocolDispatchException("rcp does not support excluded files.");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = parameterMap.get(WindowsRcpParameter.RCP_COMMAND);
        if (string2 == null) {
            string2 = WindowsRcpParameter.RCP_COMMAND.getSuggestedValue();
        } else if (!new File(string2).exists()) {
            throw new InvalidValueException(WindowsRcpParameter.RCP_COMMAND, "Cannot find specified rcp command '" + string2 + "' on local machine.");
        }
        arrayList.add(string2);
        if (parameterMap.getOrSuggest(WindowsRcpParameter.BINARY_MODE).booleanValue()) {
            arrayList.add("-b");
        }
        if (parameterMap.getOrSuggest(WindowsRcpParameter.HIDDEN_FILES).booleanValue()) {
            arrayList.add("-h");
        }
        if (copyCommand.getLocalFile().exists() && copyCommand.getLocalFile().isDirectory()) {
            arrayList.add("-r");
        } else if (copyCommand instanceof CopyFromRemoteCommand) {
            arrayList.add("-r");
        }
        String string3 = parameterMap.get(ShellParameter.FREE_FORM_PARAMETERS);
        if (string3 != null) {
            arrayList.add(string3);
        }
        if (copyCommand instanceof CopyToRemoteCommand) {
            object3 = copyCommand.getLocalFile();
            if (!((File)object3).exists()) {
                throw new ProtocolDispatchException(string + ": local file " + copyCommand.getLocalFile() + " does not exist.");
            }
            object2 = copyCommand.getRemoteFile();
            arrayList.add(this.createLocalSpecifier((File)object3));
            arrayList.add(this.createRemoteSpecifier(string, (String)object2, WindowsRcpParameter.USERNAME, parameterMap));
        } else {
            object3 = copyCommand.getRemoteFile();
            object2 = copyCommand.getLocalFile();
            arrayList.add(this.createRemoteSpecifier(string, (String)object3, WindowsRcpParameter.USERNAME, parameterMap));
            arrayList.add(this.createLocalSpecifier((File)object2));
        }
        object3 = new StringBuilder();
        for (String object4 : arrayList) {
            ((StringBuilder)object3).append(object4);
            ((StringBuilder)object3).append(" ");
        }
        object2 = new ProcessBuilder(arrayList);
        Environment environment = parameterMap.get(ShellParameter.LOCAL_ENVIRONMENT);
        if (environment != null) {
            if (environment.clearBeforeSetting()) {
                ((ProcessBuilder)object2).environment().clear();
            }
            for (String string4 : environment.keySet()) {
                ((ProcessBuilder)object2).environment().put(string4, environment.get(string4));
            }
        }
        try {
            Process iOException = ((ProcessBuilder)object2).start();
            ProcessCopyFuture processCopyFuture = new ProcessCopyFuture(iOException, ((StringBuilder)object3).toString(), string);
            Logger.LOGGER.fine(string + " " + ((StringBuilder)object3).toString() + " started");
            return processCopyFuture;
        }
        catch (IOException iOException) {
            throw new LocalProcessFailedException("Process could not start", iOException, arrayList);
        }
    }

    @Override
    public Future execute(Command command, String string, ParameterMap parameterMap) throws DispatchException {
        return this.copyFile((CopyCommand)command, string, parameterMap);
    }

    public static class WindowsRcpParameter<V>
    extends ParameterImpl<V> {
        public static final Parameter<String> USERNAME = new WindowsRcpParameter<String>(PersistentKey.USERNAME, false, true, String.class, System.getProperty("user.name"));
        public static final Parameter<String> RCP_COMMAND = new WindowsRcpParameter<String>(PersistentKey.RCP_COMMAND, false, false, String.class, "rcp");
        public static final Parameter<Boolean> BINARY_MODE = new WindowsRcpParameter<Boolean>(PersistentKey.BINARY_MODE, false, false, Boolean.class, true);
        public static final Parameter<Boolean> HIDDEN_FILES = new WindowsRcpParameter<Boolean>(PersistentKey.HIDDEN_FILES, false, false, Boolean.class, true);

        private WindowsRcpParameter(Parameter.PersistentKey persistentKey, boolean bl, boolean bl2, Class<V> clazz, V v) {
            super(persistentKey, bl, bl2, clazz, v);
        }

        @Override
        protected String getSimpleName() {
            return WindowsRcpParameter.class.getSimpleName();
        }

        private static enum PersistentKey implements Parameter.PersistentKey
        {
            USERNAME,
            RCP_COMMAND,
            BINARY_MODE,
            HIDDEN_FILES;

        }
    }
}

