/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.util;

import com.mathworks.toolbox.distcomp.remote.Logger;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public final class DaemonThreadFactory
implements ThreadFactory {
    private final AtomicInteger fCounter = new AtomicInteger(0);
    private final String fPrefix;
    private final LoggingUncaughtExceptionHandler fExceptionHandler;

    public DaemonThreadFactory(String string) {
        this.fPrefix = string;
        java.util.logging.Logger logger = Logger.LOGGER;
        this.fExceptionHandler = new LoggingUncaughtExceptionHandler(logger);
    }

    public DaemonThreadFactory(String string, java.util.logging.Logger logger) {
        this.fPrefix = string;
        this.fExceptionHandler = new LoggingUncaughtExceptionHandler(logger);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String string = this.fPrefix + this.fCounter.getAndIncrement();
        Thread thread = new Thread(runnable, string);
        thread.setUncaughtExceptionHandler(this.fExceptionHandler);
        thread.setDaemon(true);
        return thread;
    }

    private static class LoggingUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final java.util.logging.Logger fLogger;

        LoggingUncaughtExceptionHandler(java.util.logging.Logger logger) {
            this.fLogger = logger;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            this.fLogger.log(Level.SEVERE, "Thread: " + thread.getName() + ", terminated with error:", throwable);
        }
    }
}

