/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.service.PackageInfo;
import com.mathworks.toolbox.distcomp.service.PersistenceDirException;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import org.apache.commons.io.FileUtils;

public class PersistentServiceID
extends LogHandler
implements Serializable {
    private transient ReliableLog fPersistenceDir;
    private String fPersistenceDirName;
    private boolean fValuesInitialized = false;
    private Uuid fServiceID;

    public PersistentServiceID(Configuration configuration, String string) throws ConfigurationException, PersistenceDirException {
        String string2 = (String)configuration.getEntry(string, "persistenceDirectory", String.class, (Object)this.tempDirectory());
        File file = new File(string2);
        if (!(!file.exists() ? file.mkdir() : file.isDirectory())) {
            throw new PersistenceDirException("Unable to create the directory: " + string2, string2);
        }
        this.fPersistenceDirName = string2 + File.separator + "distcomp_service_id_dir";
        try {
            this.fPersistenceDir = new ReliableLog(this.fPersistenceDirName, (LogHandler)this);
        }
        catch (IOException iOException) {
            throw new PersistenceDirException("Unable to create the directory: " + this.fPersistenceDirName, iOException, this.fPersistenceDirName);
        }
        this.recover();
        if (!this.fValuesInitialized) {
            this.fServiceID = this.getDefaultServiceID();
            this.fValuesInitialized = true;
            this.snapshot();
        }
    }

    public Uuid getServiceID() {
        return this.fServiceID;
    }

    public void snapshot() throws PersistenceDirException {
        try {
            this.fPersistenceDir.snapshot();
        }
        catch (IOException iOException) {
            throw new PersistenceDirException("Unable to write files to the directory: " + this.fPersistenceDirName, iOException, this.fPersistenceDirName);
        }
    }

    public void recover() throws PersistenceDirException {
        try {
            this.fPersistenceDir.recover();
        }
        catch (IOException iOException) {
            throw new PersistenceDirException("Unable to read files from the directory: " + this.fPersistenceDirName, iOException, this.fPersistenceDirName);
        }
    }

    public void destroy() {
        this.fPersistenceDir.deletePersistentStore();
        try {
            FileUtils.deleteDirectory((File)new File(this.fPersistenceDirName));
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to delete persistence directory: " + this.fPersistenceDirName, iOException);
        }
    }

    public synchronized void applyUpdate(Object object) throws Exception {
    }

    public synchronized void recover(InputStream inputStream) throws Exception {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this.fValuesInitialized = (Boolean)objectInputStream.readObject();
        this.fServiceID = (Uuid)objectInputStream.readObject();
    }

    public synchronized void snapshot(OutputStream outputStream) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(new Boolean(this.fValuesInitialized));
        objectOutputStream.writeObject(this.fServiceID);
        objectOutputStream.flush();
    }

    private String tempDirectory() {
        CharSequence charSequence;
        String string = System.getProperty("java.io.tmpdir");
        if (File.separator.equals("\\")) {
            charSequence = new StringBuffer(string);
            for (int i = 0; i < ((StringBuffer)charSequence).length() - 1; ++i) {
                if (((StringBuffer)charSequence).charAt(i) != '\\') continue;
                ((StringBuffer)charSequence).insert(i, '\\');
                ++i;
            }
            string = ((StringBuffer)charSequence).toString();
        }
        charSequence = string + File.separator + "distcomp_tmp_dir";
        return charSequence;
    }

    private Uuid getDefaultServiceID() {
        return UuidFactory.generate();
    }
}

