/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.toolbox.distcomp.mjs.security.ClientCertificateStore;
import com.mathworks.toolbox.distcomp.service.AbstractSecureRMIClientSocketFactory;
import com.mathworks.toolbox.distcomp.util.security.SSLContextFactory;
import java.security.cert.Certificate;
import javax.net.ssl.SSLContext;

public final class TrustedSecureRMIClientSocketFactory
extends AbstractSecureRMIClientSocketFactory {
    private final Certificate fServerCertificate;
    private static Boolean sIsAlwaysTrustingServer;

    public TrustedSecureRMIClientSocketFactory(Certificate certificate) {
        this.fServerCertificate = certificate;
    }

    public TrustedSecureRMIClientSocketFactory(Certificate certificate, int n) {
        super(n);
        this.fServerCertificate = certificate;
    }

    @Override
    protected SSLContext createSSLContext() {
        if (TrustedSecureRMIClientSocketFactory.isAlwaysTrustingServer() && this.fServerCertificate != null) {
            SSLContextFactory sSLContextFactory = new SSLContextFactory();
            return sSLContextFactory.createClientSSLContext(this.fServerCertificate);
        }
        return ClientCertificateStore.getInstance().createSSLContext();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TrustedSecureRMIClientSocketFactory trustedSecureRMIClientSocketFactory = (TrustedSecureRMIClientSocketFactory)object;
        return !(this.fServerCertificate != null ? !this.fServerCertificate.equals(trustedSecureRMIClientSocketFactory.fServerCertificate) : trustedSecureRMIClientSocketFactory.fServerCertificate != null);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.fServerCertificate != null ? this.fServerCertificate.hashCode() : 0);
        return n;
    }

    private static synchronized boolean isAlwaysTrustingServer() {
        if (sIsAlwaysTrustingServer == null) {
            sIsAlwaysTrustingServer = Boolean.valueOf(System.getProperty("com.mathworks.toolbox.distcomp.rmi.alwaysTrustServer", "true"));
        }
        return sIsAlwaysTrustingServer;
    }
}

