/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage.fileblobs;

import com.mathworks.toolbox.distcomp.storage.fileblobs.ValuesExhaustedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ExponentialTreeIterator<T>
implements Serializable {
    private List<T> fNodeRepresentations;
    private ArrayList<Ring<T>> fTreeRepresentation = null;

    public ExponentialTreeIterator(List<T> list) {
        this.fNodeRepresentations = list;
    }

    public List<T> nextRepresentation() {
        if (this.fTreeRepresentation == null) {
            this.fTreeRepresentation = new ArrayList(this.fNodeRepresentations.size());
            this.fTreeRepresentation.add(new Ring<T>(this.fNodeRepresentations));
        } else {
            this.next();
        }
        return this.convertToValues(this.fTreeRepresentation);
    }

    private void next() {
        int n = this.fTreeRepresentation.size() - 1;
        Ring<T> ring = this.fTreeRepresentation.get(n);
        boolean bl = ring.increment();
        while (bl) {
            if (--n < 0) {
                throw new ValuesExhaustedException("No more values available");
            }
            ring = this.fTreeRepresentation.get(n);
            bl = ring.increment();
        }
        if (n == 0) {
            this.fTreeRepresentation.add(new Ring<T>(this.fNodeRepresentations));
        }
    }

    private List<T> convertToValues(List<Ring<T>> list) {
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        for (Ring<T> ring : list) {
            arrayList.add(ring.getValue());
        }
        return arrayList;
    }

    private static class Ring<E>
    implements Serializable {
        private List<E> fValues;
        private int fCurrentIndex;

        public Ring(List<E> list) {
            this.fValues = list;
            this.fCurrentIndex = 0;
        }

        public E getValue() {
            return this.fValues.get(this.fCurrentIndex);
        }

        public boolean increment() {
            if (this.fCurrentIndex < this.fValues.size() - 1) {
                ++this.fCurrentIndex;
                return false;
            }
            this.fCurrentIndex = 0;
            return true;
        }
    }
}

