/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.test;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerLocal;
import com.mathworks.toolbox.distcomp.logging.DistcompLevel;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.test.CommTestException;
import com.mathworks.toolbox.distcomp.test.CommTestInfo;
import com.mathworks.toolbox.distcomp.test.PackageInfo;
import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import com.mathworks.toolbox.distcomp.util.ErrorPrinter;
import com.mathworks.toolbox.distcomp.util.ErrorPrinterImpl;
import com.mathworks.toolbox.distcomp.util.NodeLocationMessage;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.logging.Level;

public final class TwoWayCommTester {
    public static final String COMM_TO_JM_MESSAGE = "This computer is unable to open a TCP connection to MJS.";
    public static final String COMM_FROM_JM_MESSAGE = "The MJS is unable to open a TCP connection back to this computer.";
    private static final String TEST_ERROR_KEY = "TEST_ERROR";

    private TwoWayCommTester() {
    }

    public static boolean testTwoWayCommunication(JobManagerLocal jobManagerLocal, CommTestInfo commTestInfo) {
        if (jobManagerLocal == null) {
            TwoWayCommTester.logNullJobManagerTestFailure(DistcompLevel.ONE, "testTwoWayCommunication");
            return false;
        }
        try {
            jobManagerLocal.testCommunicationWithClient(commTestInfo);
            TwoWayCommTester.logTestSuccess(DistcompLevel.FOUR, "testTwoWayCommunication", jobManagerLocal);
        }
        catch (RemoteException remoteException) {
            TwoWayCommTester.logTestFailure(DistcompLevel.ONE, "testTwoWayCommunication", jobManagerLocal, remoteException);
            return false;
        }
        return true;
    }

    public static boolean testTwoWayDataStoreCommunication(JobManagerLocal jobManagerLocal) {
        if (jobManagerLocal == null) {
            TwoWayCommTester.logNullJobManagerTestFailure(DistcompLevel.ONE, "testTwoWayDataStoreCommunication");
            return false;
        }
        try {
            jobManagerLocal.testTwoWayDataStoreCommunication();
            TwoWayCommTester.logTestSuccess(DistcompLevel.FOUR, "testTwoWayDataStoreCommunication", jobManagerLocal);
        }
        catch (RemoteException remoteException) {
            TwoWayCommTester.logTestFailure(DistcompLevel.ONE, "testTwoWayDataStoreCommunication", jobManagerLocal, remoteException);
            return false;
        }
        catch (MJSException mJSException) {
            TwoWayCommTester.logTestFailure(DistcompLevel.ONE, "testTwoWayDataStoreCommunication", jobManagerLocal, mJSException);
            return false;
        }
        return true;
    }

    public static TestResult testTwoWayDataStoreCommunicationAndReturnResult(JobManagerLocal jobManagerLocal) {
        if (jobManagerLocal == null) {
            TwoWayCommTester.logNullJobManagerTestFailure(DistcompLevel.ONE, "testTwoWayDataStoreCommunicationAndReturnResult");
            return new TestResult(false);
        }
        try {
            jobManagerLocal.testTwoWayDataStoreCommunication();
            TwoWayCommTester.logTestSuccess(DistcompLevel.FOUR, "testTwoWayDataStoreCommunicationAndReturnResult", jobManagerLocal);
        }
        catch (RemoteException remoteException) {
            TwoWayCommTester.logTestFailure(DistcompLevel.ONE, "testTwoWayDataStoreCommunicationAndReturnResult", jobManagerLocal, remoteException);
            return new TestResult(false, TwoWayCommTester.createTestResultMessage(jobManagerLocal, remoteException));
        }
        catch (MJSException mJSException) {
            TwoWayCommTester.logTestFailure(DistcompLevel.ONE, "testTwoWayDataStoreCommunicationAndReturnResult", jobManagerLocal, mJSException);
            return new TestResult(false, mJSException.getMessage());
        }
        return new TestResult(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createTestResultMessage(JobManagerLocal jobManagerLocal, RemoteException remoteException) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        try {
            TwoWayCommTester.printCommErrorMessage(new ErrorPrinterImpl(printStream), jobManagerLocal, remoteException);
            String string = byteArrayOutputStream.toString();
            return string;
        }
        finally {
            printStream.close();
        }
    }

    private static void logTestSuccess(Level level, String string, JobManagerLocal jobManagerLocal) {
        String string2 = jobManagerLocal.getName() + "@" + jobManagerLocal.getHostName();
        PackageInfo.LOGGER.log(level, string + " to " + string2 + " succeeded.");
    }

    private static void logTestFailure(Level level, String string, JobManagerLocal jobManagerLocal, Throwable throwable) {
        String string2 = jobManagerLocal.getName() + "@" + jobManagerLocal.getHostName();
        PackageInfo.LOGGER.log(level, string + " to " + string2 + " failed.", throwable);
    }

    private static void logNullJobManagerTestFailure(Level level, String string) {
        PackageInfo.LOGGER.log(level, string + " failed because it was passed a null job manager.");
    }

    private static void printCommErrorMessage(ErrorPrinter errorPrinter, JobManagerLocal jobManagerLocal, RemoteException remoteException) {
        String string;
        DistcompTesterException distcompTesterException;
        if (remoteException instanceof ServerException && remoteException.getCause() instanceof DistcompException) {
            Throwable throwable = remoteException.getCause().getCause();
            if (throwable instanceof CommTestException) {
                throwable = throwable.getCause();
            }
            distcompTesterException = new DistcompTesterException(throwable);
            string = TwoWayCommTester.commFromJobManagerMessage(jobManagerLocal);
        } else {
            distcompTesterException = new DistcompTesterException(remoteException);
            string = TwoWayCommTester.commToJobManagerMessage(jobManagerLocal);
        }
        errorPrinter.printError(string, distcompTesterException);
    }

    private static String commToJobManagerMessage(JobManagerLocal jobManagerLocal) {
        String string = jobManagerLocal.getHostName();
        return "\nThis computer is unable to open a TCP connection to MJS.\n\nYou will not be able to interact with this MJS.\n\n======================================================\nPossible reasons for this problem are:\n\t1. MJS has crashed or shut down.\n\t2. A firewall is blocking communication between this computer and '" + string + "'.\n" + "\t3. Network routers are unable to route traffic from this computer to '" + string + "'.\n" + "\t4. This computer cannot resolve the short hostname of '" + jobManagerLocal.getLookupURL() + "'.\n" + "\t5. '" + string + "' has multiple hostnames and is using one which is unresolvable on this computer." + "\n\n" + NodeLocationMessage.clientLocationMessage() + "\n\n" + NodeLocationMessage.jobManagerLocationMessage(jobManagerLocal) + "\n======================================================\n";
    }

    private static String commFromJobManagerMessage(JobManagerLocal jobManagerLocal) {
        String string = jobManagerLocal.getHostName();
        return "\nThe MJS is unable to open a TCP connection back to this computer.\n\nYou will not be able to transfer data of size greater than " + jobManagerLocal.getDataStoreMinLimit() + " bytes\n" + "between this computer and '" + string + "'. Callback functions will also not work." + "\n\n======================================================\n" + "Possible reasons for this problem are:\n" + "\t1. '" + string + "' cannot resolve the short hostname of this computer.\n" + "\t2. This computer has multiple hostnames and the Parallel Computing Toolbox is\n" + "\t   using one that is unresolvable on '" + string + "'.\n" + "\t3. A firewall is blocking communication between '" + string + "' and this computer.\n" + "\t4. Network routers are unable to route traffic from '" + string + "' to this computer.\n\n" + "Refer to the Troubleshooting section of the documentation for detailed debugging instructions." + "\n\n" + NodeLocationMessage.clientLocationMessage() + "\n\n" + NodeLocationMessage.jobManagerLocationMessage(jobManagerLocal) + "\n======================================================\n";
    }

    private static class DistcompTesterException
    extends DistcompDiagnosticException {
        DistcompTesterException(Throwable throwable) {
            super(throwable, TwoWayCommTester.TEST_ERROR_KEY, new Object[0]);
        }
    }

    public static class TestResult {
        private final boolean fSuccess;
        private final String fErrorMessage;

        TestResult(boolean bl) {
            this.fSuccess = bl;
            this.fErrorMessage = null;
        }

        TestResult(boolean bl, String string) {
            this.fSuccess = bl;
            this.fErrorMessage = string;
        }

        public boolean isSuccess() {
            return this.fSuccess;
        }

        public String getErrorMessage() {
            return this.fErrorMessage;
        }
    }
}

