/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.discover;

import com.jidesoft.grid.SortableTable;
import com.jidesoft.wizard.DefaultWizardPage;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.jmi.Callback;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.distcomp.ui.discover.ClusterTableModel;
import com.mathworks.toolbox.distcomp.ui.discover.DiscoverClusterData;
import com.mathworks.toolbox.distcomp.ui.discover.PageActionProvider;
import com.mathworks.toolbox.distcomp.ui.discover.model.DiscoverClusterWizardModel;
import com.mathworks.toolbox.distcomp.ui.panel.AbstractStyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.resources.icons.ParallelIcon;
import com.mathworks.toolbox.distcomp.ui.widget.TablePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

final class ClusterTablePage
extends DefaultWizardPage
implements PropertyChangeListener,
PageActionProvider {
    private final Callback fCreateProfileCallback = new Callback();
    private final DiscoverClusterWizardModel fDiscoverClusterModel;
    private JLabel fOverallStatusLabel;
    private TablePanel fClusterTablePanel;
    private JLabel fWarningLabel;
    private StyleGuidePanel fClusterFoundPanel;
    private StyleGuidePanel fClusterNotFoundPanel;
    private AbstractStyleGuidePanel fContentPane;
    private static final String MJS_TYPE = "MJS";
    private static final String MJS_COMPUTE_CLOUD_TYPE = "MJSComputeCloud";
    private static final String HPC_SERVER_TYPE = "HPCServer";
    private MJLabel fSelectLabel;
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");

    ClusterTablePage(DiscoverClusterWizardModel discoverClusterWizardModel) {
        super(sRes.getString("DiscoverDialog.ClusterTablePage"));
        this.fDiscoverClusterModel = discoverClusterWizardModel;
        this.fDiscoverClusterModel.addPropertyChangeListener(this);
        this.fContentPane = new StyleGuideEmptyPanel();
        this.createClusterFoundPanel();
        this.createClusterNotFoundPanel();
        this.addComponent((JComponent)((Object)this.fContentPane), true);
        this.fWarningLabel.setName("WarningLabel");
        this.fOverallStatusLabel.setName("ClusterTablePage.StatusLabel");
    }

    private void createClusterFoundPanel() {
        this.fOverallStatusLabel = new MJLabel();
        this.fClusterTablePanel = this.createClusterTable();
        this.fSelectLabel = new MJLabel(sRes.getString("DiscoverDialog.SelectClusterLabel"));
        this.fWarningLabel = new MJLabel();
        JPanel jPanel = new JPanel();
        jPanel.setMinimumSize(new Dimension(0, 20));
        this.fClusterFoundPanel = new StyleGuidePanel();
        this.fClusterFoundPanel.addLine(this.fOverallStatusLabel);
        this.fClusterFoundPanel.addLine(jPanel);
        this.fClusterFoundPanel.addLine((JComponent)this.fSelectLabel);
        this.fClusterFoundPanel.addLine((JComponent)((Object)this.fClusterTablePanel), 8);
        this.fClusterFoundPanel.addLine(this.fWarningLabel);
    }

    private void createClusterNotFoundPanel() {
        MJLabel mJLabel = new MJLabel(sRes.getString("DiscoverDialog.StatusLabel.DiscoveryDone.NoneFound"));
        mJLabel.setIcon(DialogIcon.WARNING_32x32.getIcon());
        mJLabel.setName("ClusterTablePage.ClusterNotFoundWarningLabel");
        MJLabel mJLabel2 = new MJLabel(sRes.getString("DiscoverDialog.WarningLabel.NoneFound"));
        this.fClusterNotFoundPanel = new StyleGuidePanel();
        this.fClusterNotFoundPanel.addLine((JComponent)mJLabel);
        this.fClusterNotFoundPanel.addLine((JComponent)mJLabel2);
        this.fClusterNotFoundPanel.addLine(new JPanel(), 8);
    }

    public void setupWizardButtons() {
        super.setupWizardButtons();
        this.fireButtonEvent(3300, "BACK");
        this.fireButtonEvent(3300, "FINISH");
        this.fireButtonEvent(3299, "NEXT");
        this.fireButtonEvent(3299, "CANCEL");
        this.setupNextButton();
        this.fireButtonEvent(3301, "CANCEL");
    }

    private void setupNextButton() {
        if (this.fClusterTablePanel.getSelectedRow() != -1) {
            this.fireButtonEvent(3301, "NEXT");
        } else {
            this.fireButtonEvent(3302, "NEXT");
        }
    }

    public boolean showBannerPane() {
        return false;
    }

    private TablePanel createClusterTable() {
        ClusterTableModel clusterTableModel = new ClusterTableModel(this.fDiscoverClusterModel.getDiscoveredClusters());
        TablePanel tablePanel = new TablePanel(clusterTableModel, "DiscoverClusterTable");
        tablePanel.setCustomRenderer(3, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalTextPosition(10);
                int n3 = ((SortableTable)jTable).getActualRowAt(n);
                DiscoverClusterData discoverClusterData = ClusterTablePage.this.fDiscoverClusterModel.getDiscoveredClusters().get(n3);
                if (discoverClusterData.isSecure()) {
                    jLabel.setIcon(ParallelIcon.LOCK.getIcon());
                    jLabel.setToolTipText(sRes.getString("DiscoverDialog.ClusterTable.Lock.Tooltip"));
                } else {
                    jLabel.setIcon(null);
                    jLabel.setToolTipText(null);
                }
                String string = discoverClusterData.getType();
                if (string.equals(ClusterTablePage.MJS_TYPE) || string.equals(ClusterTablePage.MJS_COMPUTE_CLOUD_TYPE)) {
                    string = sRes.getString("DiscoverDialog.ClusterTable.Type.MJS");
                } else if (string.equals(ClusterTablePage.HPC_SERVER_TYPE)) {
                    string = sRes.getString("DiscoverDialog.ClusterTable.Type.HPCServer");
                }
                jLabel.setText(string);
                return jLabel;
            }
        });
        tablePanel.setCustomRenderer(4, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                String string = ClusterTablePage.generateCommaSeperatedList(object);
                jLabel.setText(string);
                return jLabel;
            }
        });
        tablePanel.setCustomRenderer(2, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setHorizontalAlignment(4);
                return jLabel;
            }
        });
        tablePanel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    return;
                }
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = ClusterTablePage.this.fClusterTablePanel.getSelectedRow();
                    ClusterTablePage.this.fDiscoverClusterModel.setSelectedCluster(ClusterTablePage.this.fDiscoverClusterModel.getDiscoveredClusters().get(n));
                }
            }
        });
        return tablePanel;
    }

    private static String generateCommaSeperatedList(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object != null && object instanceof String[] && ((String[])object).length != 0) {
            String[] stringArray;
            for (String string : stringArray = (String[])object) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("ClusterList")) {
            this.fSelectLabel.setVisible(true);
            this.fClusterTablePanel.updateTable();
        } else if (string.equals("DiscoveryStarted")) {
            this.fOverallStatusLabel.setText(sRes.getString("DiscoverDialog.StatusLabel.DiscoveryStarted"));
            this.fOverallStatusLabel.setIcon(ParallelIcon.BUSY.getIcon());
            this.fClusterTablePanel.clearSelectedRow();
            this.fClusterTablePanel.updateTable();
            this.fWarningLabel.setText("");
            this.fWarningLabel.setIcon(null);
            this.fContentPane.removeAll();
            this.fContentPane.addLine((JComponent)((Object)this.fClusterFoundPanel), 8);
            this.fContentPane.revalidate();
            this.fContentPane.repaint();
        } else if (string.equals("DiscoveryDone")) {
            if (this.fClusterTablePanel.getRowCount() > 0) {
                this.fOverallStatusLabel.setText(sRes.getString("DiscoverDialog.StatusLabel.DiscoveryDone"));
                this.fOverallStatusLabel.setIcon(ParallelIcon.PASSED.getIcon());
                this.fSelectLabel.setVisible(true);
            } else {
                this.fContentPane.removeAll();
                this.fContentPane.addLine((JComponent)((Object)this.fClusterNotFoundPanel), 8);
                this.fContentPane.revalidate();
                this.fContentPane.repaint();
                this.fireButtonEvent(3300, "NEXT");
                this.fireButtonEvent(3300, "CANCEL");
                this.fireButtonEvent(3299, "FINISH");
                this.fireButtonEvent(3301, "FINISH");
            }
        } else if (string.equals("SelectedCluster")) {
            boolean bl;
            this.setupNextButton();
            boolean bl2 = bl = this.fDiscoverClusterModel.getSelectedCluster() != null && this.fDiscoverClusterModel.getSelectedCluster().getCorrespondingProfileNames() != null && this.fDiscoverClusterModel.getSelectedCluster().getCorrespondingProfileNames().length != 0;
            if (bl) {
                this.fWarningLabel.setText(sRes.getString("DiscoverDialog.WarningLabel.MultipleProfilesFound"));
                this.fWarningLabel.setIcon(DialogIcon.WARNING.getIcon());
            } else {
                this.fWarningLabel.setText("");
                this.fWarningLabel.setIcon(null);
            }
        }
    }

    @Override
    public void doCancel() {
        this.fireButtonEvent(3302, "NEXT");
        this.fireButtonEvent(3302, "CANCEL");
        this.fDiscoverClusterModel.setUserCancelled(true);
    }

    @Override
    public void doNext() {
        this.fireButtonEvent(3302, "NEXT");
        this.fireButtonEvent(3302, "CANCEL");
        this.fDiscoverClusterModel.setUserCancelled(true);
        this.fCreateProfileCallback.postCallback();
    }

    @Override
    public void doFinish() {
    }

    public Callback getCallback() {
        return this.fCreateProfileCallback;
    }
}

