/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class LightBoxGlassPane
extends JComponent {
    private JComponent fComponent;
    private Component fMousePressedComponent;
    private static final Color BACKGROUND_COLOR = new Color(Color.BLACK.getRed(), Color.BLACK.getGreen(), Color.BLACK.getBlue(), 128);

    public LightBoxGlassPane(JComponent jComponent) {
        this.fComponent = jComponent;
        this.setOpaque(false);
        this.setBackground(BACKGROUND_COLOR);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                LightBoxGlassPane.this.redispatchMouseEvent(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LightBoxGlassPane.this.updateMousePressedComponent(mouseEvent);
                LightBoxGlassPane.this.redispatchMouseEvent(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                LightBoxGlassPane.this.redispatchEventToPressedComponent(mouseEvent);
                LightBoxGlassPane.this.resetMousePressedComponent();
                LightBoxGlassPane.this.redispatchMouseEvent(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LightBoxGlassPane.this.redispatchMouseEvent(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LightBoxGlassPane.this.redispatchMouseEvent(mouseEvent);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                LightBoxGlassPane.this.redispatchEventToPressedComponent(mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                LightBoxGlassPane.this.redispatchEventToPressedComponent(mouseEvent);
            }
        });
    }

    private void resetMousePressedComponent() {
        this.fMousePressedComponent = null;
    }

    private void updateMousePressedComponent(MouseEvent mouseEvent) {
        this.resetMousePressedComponent();
        Point point = mouseEvent.getPoint();
        Point point2 = SwingUtilities.convertPoint(this, point, this.getContentPane());
        if (!this.contains(point2)) {
            return;
        }
        Component component = SwingUtilities.getDeepestComponentAt(this.getContentPane(), point2.x, point2.y);
        if (component != null && SwingUtilities.isDescendingFrom(component, this.fComponent) && !(component instanceof JButton)) {
            this.fMousePressedComponent = component;
        }
    }

    private void redispatchEventToPressedComponent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Point point2 = SwingUtilities.convertPoint(this, point, this.getContentPane());
        if (!this.contains(point2)) {
            return;
        }
        if (this.fMousePressedComponent != null) {
            Point point3 = SwingUtilities.convertPoint(this, point, this.fMousePressedComponent);
            this.fMousePressedComponent.dispatchEvent(new MouseEvent(this.fMousePressedComponent, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point3.x, point3.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }
    }

    private void redispatchMouseEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Point point2 = SwingUtilities.convertPoint(this, point, this.getContentPane());
        if (!this.contains(point2)) {
            return;
        }
        Component component = SwingUtilities.getDeepestComponentAt(this.getContentPane(), point2.x, point2.y);
        if (component != null && SwingUtilities.isDescendingFrom(component, this.fComponent)) {
            Point point3 = SwingUtilities.convertPoint(this, point, component);
            component.dispatchEvent(new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point3.x, point3.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        Rectangle rectangle2 = this.getVisibleRectangle(this.fComponent);
        Rectangle[] rectangleArray = SwingUtilities.computeDifference(rectangle, rectangle2);
        graphics.setColor(this.getBackground());
        for (Rectangle rectangle3 : rectangleArray) {
            graphics.fillRect((int)rectangle3.getX(), (int)rectangle3.getY(), (int)rectangle3.getWidth(), (int)rectangle3.getHeight());
        }
    }

    private Rectangle getVisibleRectangle(JComponent jComponent) {
        Point point = jComponent.getLocationOnScreen();
        SwingUtilities.convertPointFromScreen(point, this.getContentPane());
        return new Rectangle((int)point.getX(), (int)point.getY(), jComponent.getWidth(), jComponent.getHeight());
    }

    private Component getContentPane() {
        Container container = null;
        Window window = SwingUtilities.windowForComponent(this);
        if (window instanceof JFrame || window instanceof JDialog) {
            container = ((RootPaneContainer)((Object)window)).getContentPane();
        } else assert (false) : "Unknown window";
        return container;
    }
}

