/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationNotFoundException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;

public class ConfigFileWrapper {
    private Configuration fConfig;
    private String fComponent;
    private static String sDefaultComponent = "com.sun.jini.start";

    private Configuration createConfig(String[] stringArray) throws ConfigurationException {
        try {
            return ConfigurationProvider.getInstance((String[])stringArray);
        }
        catch (ConfigurationNotFoundException configurationNotFoundException) {
            throw configurationNotFoundException;
        }
        catch (ConfigurationException configurationException) {
            throw new ConfigurationException("Problem reading configuration file.", (Throwable)configurationException);
        }
    }

    public ConfigFileWrapper(String[] stringArray) throws ConfigurationException {
        this.fConfig = null;
        this.fComponent = sDefaultComponent;
        this.fConfig = this.createConfig(stringArray);
    }

    public ConfigFileWrapper(String[] stringArray, String string) throws ConfigurationException {
        this.fConfig = null;
        this.fComponent = string;
        this.fConfig = this.createConfig(stringArray);
    }

    public ConfigFileWrapper(Configuration configuration, String string) {
        this.fConfig = configuration;
        this.fComponent = string;
    }

    public String getStringEntry(String string) throws ConfigurationException {
        String string2 = (String)this.getEntry(string, String.class);
        return string2;
    }

    public String getNonEmptyStringEntry(String string) throws ConfigurationException {
        String string2 = (String)this.getEntry(string, String.class);
        if (string2.length() == 0) {
            throw new ConfigurationException("Entry for " + string + " is empty.");
        }
        return string2;
    }

    public int getIntEntry(String string) throws ConfigurationException {
        int n = (Integer)this.getEntry(string, Integer.TYPE);
        return n;
    }

    public int getIntEntry(String string, int n) {
        try {
            return this.getIntEntry(string);
        }
        catch (Exception exception) {
            try {
                return Integer.parseInt(this.getStringEntry(string));
            }
            catch (Exception exception2) {
                return n;
            }
        }
    }

    public boolean getBooleanEntry(String string) throws ConfigurationException {
        boolean bl = (Boolean)this.getEntry(string, Boolean.class);
        return bl;
    }

    public boolean getBooleanEntry(String string, boolean bl) {
        try {
            return this.getBooleanEntry(string);
        }
        catch (Exception exception) {
            try {
                return Boolean.valueOf(this.getStringEntry(string));
            }
            catch (Exception exception2) {
                return bl;
            }
        }
    }

    public Object getEntry(String string, Class clazz) throws ConfigurationException {
        try {
            return this.fConfig.getEntry(this.fComponent, string, clazz);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            Exception exception = new Exception("No entry found for " + string + ".");
            throw new NoSuchEntryException("Problem reading configuration file.", (Throwable)exception);
        }
        catch (ConfigurationNotFoundException configurationNotFoundException) {
            throw configurationNotFoundException;
        }
        catch (ConfigurationException configurationException) {
            throw new ConfigurationException("Problem reading configuration file.", (Throwable)configurationException);
        }
    }

    public Configuration getConfiguration() {
        return this.fConfig;
    }
}

