/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import java.io.File;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class FileDeleter
implements Runnable {
    private static FileDeleter sInstance = null;
    private static long sTimeout = 10000L;
    private Queue<File> fQueue = new ConcurrentLinkedQueue<File>();
    private Thread fDeletionThread;

    public static boolean deleteFile(File file) {
        if (!file.exists()) {
            return true;
        }
        boolean bl = FileDeleter.recursiveDelete(file);
        if (!bl) {
            FileDeleter.getInstance().deleteFileLater(file);
        }
        return bl;
    }

    public static FileDeleter getInstance() {
        if (sInstance == null) {
            sInstance = new FileDeleter();
        }
        return sInstance;
    }

    public static void setThreadTimeout(long l) {
        sTimeout = l;
    }

    public synchronized void deleteFileLater(File file) {
        assert (file != null) : "Can't have null files added to a ConcurrentLinkedQueue";
        this.fQueue.add(file);
        this.ensureDeletionThreadExists();
    }

    private void ensureDeletionThreadExists() {
        if (this.fDeletionThread == null) {
            this.fDeletionThread = new Thread(this);
            this.fDeletionThread.start();
        }
    }

    public synchronized boolean isThreadActive() {
        return this.fDeletionThread != null;
    }

    public File[] getCurrentDeletionList() {
        return this.fQueue.toArray(new File[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object object;
            Thread.sleep(sTimeout);
            Iterator iterator = this.fQueue.iterator();
            while (iterator.hasNext()) {
                object = (File)iterator.next();
                try {
                    if (((File)object).exists() && !FileDeleter.recursiveDelete((File)object)) continue;
                    iterator.remove();
                }
                catch (SecurityException securityException) {
                    iterator.remove();
                }
            }
            object = this;
            synchronized (object) {
                try {
                    if (this.fQueue.isEmpty()) {
                        this.fDeletionThread = null;
                    }
                    return;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (InterruptedException interruptedException) {
                        FileDeleter fileDeleter = this;
                        synchronized (fileDeleter) {
                            this.fDeletionThread = null;
                        }
                    }
                }
            }
        }
        finally {
            FileDeleter fileDeleter = this;
            synchronized (fileDeleter) {
                this.fDeletionThread = null;
            }
        }
        {
            return;
        }
    }

    private static boolean recursiveDelete(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (FileDeleter.recursiveDelete(file2)) continue;
                return false;
            }
        }
        return file.delete();
    }
}

