/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.util.Executor;
import com.mathworks.toolbox.distcomp.util.SyncBlockingQueue;
import java.io.PrintWriter;
import java.io.StringWriter;

public class FixedThreadPool
implements Executor {
    private CmdThread[] fThreads;
    private final SyncBlockingQueue fSyncQueue;

    public static FixedThreadPool create(int n) {
        FixedThreadPool fixedThreadPool = new FixedThreadPool(n);
        fixedThreadPool.start();
        return fixedThreadPool;
    }

    private FixedThreadPool(int n) {
        assert (n > 0) : "Number of threads must be > 0, was " + n + ".";
        this.fSyncQueue = new SyncBlockingQueue();
        this.fThreads = new CmdThread[n];
        for (int i = 0; i < n; ++i) {
            this.fThreads[i] = new CmdThread();
        }
    }

    private void start() {
        for (int i = 0; i < this.fThreads.length; ++i) {
            this.fThreads[i].start();
        }
    }

    @Override
    public void execute(Runnable runnable) throws Executor.ExecutorDestroyedException {
        assert (runnable != null) : "Runnables should not be null.";
        try {
            this.fSyncQueue.addLast(runnable);
        }
        catch (SyncBlockingQueue.QueueDestroyedException queueDestroyedException) {
            throw new Executor.ExecutorDestroyedException();
        }
    }

    @Override
    public void destroy() {
        assert (this.fSyncQueue.isAlive()) : "Executor being destroyed more than once.";
        assert (this.getNumRunningThreads() == this.fThreads.length) : "Found threads that were not running during a call to destroy.";
        this.fSyncQueue.destroy();
    }

    public int getNumRunningThreads() {
        int n = 0;
        for (int i = 0; i < this.fThreads.length; ++i) {
            if (!this.fThreads[i].isAlive()) continue;
            ++n;
        }
        return n;
    }

    private class CmdThread
    extends Thread {
        private CmdThread() {
            this.setDaemon(true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (true) {
                Runnable runnable;
                try {
                    runnable = (Runnable)FixedThreadPool.this.fSyncQueue.removeFirst();
                }
                catch (SyncBlockingQueue.QueueDestroyedException queueDestroyedException) {
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                try {
                    runnable.run();
                    continue;
                }
                catch (Throwable throwable) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    throwable.printStackTrace(printWriter);
                    printWriter.flush();
                    assert (false) : "Runnable threw an exception in FixedThreadPool: " + stringWriter;
                    continue;
                }
                break;
            }
        }
    }
}

