/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.jobmanager.JobManager;
import com.mathworks.toolbox.distcomp.util.Accessor;
import com.mathworks.toolbox.distcomp.worker.Worker;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryManagement;
import net.jini.lookup.entry.Name;

public abstract class JiniAccessor
implements Accessor {
    private static final Entry[] ALL_ENTRIES = null;

    protected JiniAccessor() {
        Logger logger = Logger.getLogger("com.sun.jini.reggie");
        Logger logger2 = Logger.getLogger("net.jini.discovery");
        logger.setLevel(Level.OFF);
        logger2.setLevel(Level.OFF);
    }

    @Override
    public Object[] getMLWorkers(String string) {
        Entry[] entryArray = ALL_ENTRIES;
        if (string != null) {
            entryArray = new Entry[]{new Name(string)};
        }
        Class[] classArray = new Class[]{Worker.class};
        return this.getServicesByClass(classArray, entryArray);
    }

    @Override
    public Object[] getJobManagers(String string) {
        Entry[] entryArray = ALL_ENTRIES;
        if (string != null && !string.isEmpty()) {
            entryArray = new Entry[]{new Name(string)};
        }
        Class[] classArray = new Class[]{JobManager.class};
        return this.getServicesByClass(classArray, entryArray);
    }

    public boolean lookupServiceFound() {
        Object[] objectArray = this.findLUS();
        return objectArray.length != 0;
    }

    private Object[] findLUS() {
        Class[] classArray = new Class[]{ServiceRegistrar.class};
        return this.getServicesByClass(classArray, null);
    }

    protected synchronized void waitForDiscovery(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = System.currentTimeMillis();
        while (l3 - l2 < l) {
            try {
                if (this.lookupServiceFound()) break;
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l3 = System.currentTimeMillis();
        }
    }

    private ServiceItem[] serviceLookup(Class[] classArray, Entry[] entryArray) {
        ServiceTemplate serviceTemplate = new ServiceTemplate(null, classArray, entryArray);
        ServiceRegistrar[] serviceRegistrarArray = this.getRegistrars();
        LinkedList<ServiceItem> linkedList = new LinkedList<ServiceItem>();
        for (ServiceRegistrar serviceRegistrar : serviceRegistrarArray) {
            try {
                ServiceMatches serviceMatches = serviceRegistrar.lookup(serviceTemplate, Integer.MAX_VALUE);
                linkedList.addAll(Arrays.asList(serviceMatches.items));
            }
            catch (RemoteException remoteException) {
                this.discardServiceRegistrar(serviceRegistrar);
            }
        }
        return linkedList.toArray(new ServiceItem[linkedList.size()]);
    }

    private Object[] getServicesByClass(Class[] classArray, Entry[] entryArray) {
        ServiceItem[] serviceItemArray = this.serviceLookup(classArray, entryArray);
        Hashtable<ServiceID, Object> hashtable = new Hashtable<ServiceID, Object>(serviceItemArray.length);
        for (int i = 0; i < serviceItemArray.length; ++i) {
            if (serviceItemArray[i].service == null) continue;
            hashtable.put(serviceItemArray[i].serviceID, serviceItemArray[i].service);
        }
        return hashtable.values().toArray();
    }

    protected abstract DiscoveryManagement getDiscoverer();

    private ServiceRegistrar[] getRegistrars() {
        DiscoveryManagement discoveryManagement = this.getDiscoverer();
        return discoveryManagement.getRegistrars();
    }

    private void discardServiceRegistrar(ServiceRegistrar serviceRegistrar) {
        DiscoveryManagement discoveryManagement = this.getDiscoverer();
        discoveryManagement.discard(serviceRegistrar);
    }
}

