/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerLocal;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.service.ServiceAccessor;
import com.mathworks.toolbox.distcomp.util.AllowAllSecurityManager;

public final class JobManagerFinder {
    private static final int MAX_FIND_ATTEMPTS = 20;
    private static final long PAUSE_BETWEEN_ATTEMPTS = 250L;
    private final String fJobManagerName;
    private final String fJobManagerLookupURL;

    public JobManagerFinder(String string, String string2) {
        this.fJobManagerName = string;
        this.fJobManagerLookupURL = string2;
    }

    public JobManagerLocal findJobManager(int n, long l) throws JobManagerFindException {
        for (int i = n; i > 0; --i) {
            JobManagerLocal[] jobManagerLocalArray;
            try {
                jobManagerLocalArray = ServiceAccessor.getJobManagers(this.fJobManagerLookupURL, this.fJobManagerName);
            }
            catch (DistcompException distcompException) {
                throw new JobManagerFindException("Unable to get job manager proxies", distcompException);
            }
            catch (MJSException mJSException) {
                throw new JobManagerFindException("Unable to get job manager proxies", mJSException);
            }
            for (JobManagerLocal jobManagerLocal : jobManagerLocalArray) {
                if (!jobManagerLocal.testCommunication()) continue;
                return jobManagerLocal;
            }
            try {
                Thread.sleep(l);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new JobManagerFindException(String.format("Could not find the jobmanager %s on host %s", this.fJobManagerName, this.fJobManagerLookupURL));
    }

    public JobManagerLocal findJobManager() throws JobManagerFindException {
        return this.findJobManager(20, 250L);
    }

    static {
        System.setSecurityManager(new AllowAllSecurityManager());
    }

    public static class JobManagerFindException
    extends Exception {
        JobManagerFindException(String string) {
            super(string);
        }

        JobManagerFindException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

