/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import java.util.LinkedList;

public class SyncBlockingQueue {
    private LinkedList<Object> fQueue = new LinkedList();
    private boolean fIsAlive = true;

    public synchronized void addLast(Object object) throws QueueDestroyedException {
        if (!this.fIsAlive) {
            throw new QueueDestroyedException();
        }
        this.fQueue.addLast(object);
        this.notify();
    }

    public synchronized Object removeFirst() throws InterruptedException {
        while (this.fQueue.isEmpty() && this.fIsAlive) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (!this.fIsAlive) {
                    throw new QueueDestroyedException();
                }
                throw interruptedException;
            }
        }
        if (this.fIsAlive) {
            return this.fQueue.removeFirst();
        }
        throw new QueueDestroyedException();
    }

    public synchronized void destroy() {
        assert (this.fIsAlive) : "The destroy method has already been called.";
        this.fIsAlive = false;
        this.fQueue.clear();
        this.notifyAll();
    }

    public synchronized boolean isAlive() {
        return this.fIsAlive;
    }

    public synchronized boolean isEmpty() throws QueueDestroyedException {
        if (!this.fIsAlive) {
            throw new QueueDestroyedException();
        }
        return this.fQueue.isEmpty();
    }

    public synchronized SyncBlockingQueue moveInto() throws QueueDestroyedException {
        if (!this.fIsAlive) {
            throw new QueueDestroyedException();
        }
        SyncBlockingQueue syncBlockingQueue = new SyncBlockingQueue();
        syncBlockingQueue.fIsAlive = this.fIsAlive;
        while (!this.fQueue.isEmpty()) {
            syncBlockingQueue.fQueue.addLast(this.fQueue.removeFirst());
        }
        return syncBlockingQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveInto(SyncBlockingQueue syncBlockingQueue) throws QueueDestroyedException {
        SyncBlockingQueue syncBlockingQueue2 = this.moveInto();
        SyncBlockingQueue syncBlockingQueue3 = syncBlockingQueue;
        synchronized (syncBlockingQueue3) {
            syncBlockingQueue.fIsAlive = syncBlockingQueue2.fIsAlive;
            while (!syncBlockingQueue2.fQueue.isEmpty()) {
                syncBlockingQueue.fQueue.addLast(syncBlockingQueue2.fQueue.removeFirst());
            }
        }
    }

    public static class QueueDestroyedException
    extends InterruptedException {
    }
}

