/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompProxy;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerProxy;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.datastore.DataStoreException;
import com.mathworks.toolbox.distcomp.mjs.datastore.InvocationWithDataStore;
import com.mathworks.toolbox.distcomp.mjs.datastore.LargeData;
import com.mathworks.toolbox.distcomp.mjs.datastore.LargeDataInvoker;
import com.mathworks.toolbox.distcomp.mjs.datastore.NullLargeDataInvokerException;
import com.mathworks.toolbox.distcomp.mjs.datastore.TransferableData;
import com.mathworks.toolbox.distcomp.workunit.DistcompAccessLocal;
import com.mathworks.toolbox.distcomp.workunit.DistcompAccessRemote;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;

public abstract class DistcompAccessProxy
extends DistcompProxy
implements DistcompAccessLocal {
    private static final long serialVersionUID = 1L;
    protected JobManagerProxy fJobManager;
    private LargeDataInvoker fLargeDataInvoker;
    private long fDataStoreMinLimit;

    protected DistcompAccessProxy(DistcompAccessRemote distcompAccessRemote, long l, JobManagerProxy jobManagerProxy) throws DistcompProxy.SerializeProxyException {
        super(distcompAccessRemote);
        this.fJobManager = jobManagerProxy;
        this.fDataStoreMinLimit = l;
    }

    public void initLargeDataInvoker(LargeDataInvoker largeDataInvoker) {
        this.fLargeDataInvoker = largeDataInvoker;
    }

    private LargeDataInvoker getLargeDataInvoker() throws NullLargeDataInvokerException {
        if (this.fLargeDataInvoker == null) {
            throw new NullLargeDataInvokerException("Client not configured correctly.");
        }
        return this.fLargeDataInvoker;
    }

    private void clearDataStore() {
        this.fLargeDataInvoker.clearDataStore();
    }

    protected TransferableData[] putLargeInputsInDataStore(LargeData[] largeDataArray) throws DistcompException, DataStoreException {
        return this.getLargeDataInvoker().putLargeInputsInDataStore(largeDataArray);
    }

    protected TransferableData[] appendLargeInputsToDataStore(LargeData[] largeDataArray) throws DistcompException, DataStoreException {
        return this.getLargeDataInvoker().appendLargeInputsToDataStore(largeDataArray);
    }

    protected LargeData[] getLargeOutputsFromDataStore(LargeData[] largeDataArray) throws DistcompException, DataStoreException {
        return this.getLargeDataInvoker().getLargeOutputsFromDataStore(largeDataArray);
    }

    private <T> T invokeWithDataStore(InvocationWithDataStore<T> invocationWithDataStore) throws RemoteException, MJSException {
        return this.getLargeDataInvoker().invokeWithDataStore(invocationWithDataStore);
    }

    public long getDataStoreMinLimit() {
        return this.fDataStoreMinLimit;
    }

    @Override
    public long getDataStoreSize() throws NullLargeDataInvokerException {
        return this.getLargeDataInvoker().getDataStoreSize();
    }

    @Override
    public int getDataStoreExportPort() throws NullLargeDataInvokerException {
        return this.getLargeDataInvoker().getDataStoreExportPort();
    }

    protected Object invokeAndRetry(InvocationAndRetry invocationAndRetry) throws MJSException, RemoteException {
        try {
            return invocationAndRetry.invoke();
        }
        catch (RemoteException remoteException) {
            if (this.shouldRetryOn(remoteException)) {
                this.updateDistcompProxy();
                return invocationAndRetry.invoke();
            }
            throw remoteException;
        }
    }

    protected <T> T setInvokeAndRetryWithDataStore(InvocationAndRetryWithDataStore<T> invocationAndRetryWithDataStore) throws RemoteException, MJSException {
        try {
            T t = this.invokeWithDataStore(invocationAndRetryWithDataStore);
            return t;
        }
        catch (MJSException mJSException) {
            if (mJSException.getCause() instanceof RemoteException) {
                throw new DataStoreException("Failed to contact data store", mJSException);
            }
            throw mJSException;
        }
        catch (RemoteException remoteException) {
            if (this.shouldRetryOn(remoteException)) {
                this.updateDistcompProxy();
                T t = this.invokeWithDataStore(invocationAndRetryWithDataStore);
                return t;
            }
            throw remoteException;
        }
        finally {
            this.clearDataStore();
        }
    }

    protected <T> T getInvokeAndRetryWithDataStore(InvocationAndRetryWithDataStore<T> invocationAndRetryWithDataStore) throws RemoteException, MJSException {
        this.clearDataStore();
        try {
            return this.invokeWithDataStore(invocationAndRetryWithDataStore);
        }
        catch (MJSException mJSException) {
            if (mJSException.getCause() instanceof RemoteException) {
                throw new DataStoreException("Failed to contact data store", mJSException);
            }
            throw mJSException;
        }
        catch (RemoteException remoteException) {
            if (this.shouldRetryOn(remoteException)) {
                this.updateDistcompProxy();
                return this.invokeWithDataStore(invocationAndRetryWithDataStore);
            }
            throw remoteException;
        }
    }

    protected abstract void updateDistcompProxy() throws RemoteException, MJSException;

    private boolean shouldRetryOn(Throwable throwable) {
        return throwable instanceof NoSuchObjectException || throwable instanceof ConnectException || throwable instanceof ConnectIOException;
    }

    public static abstract class InvocationAndRetryWithDataStore<T>
    extends InvocationWithDataStore<T> {
        @Override
        public abstract T invoke() throws RemoteException, MJSException;
    }

    public static interface InvocationAndRetry {
        public Object invoke() throws MJSException, RemoteException;
    }
}

