/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import java.io.Serializable;
import net.jini.id.Uuid;

public final class TaskAttemptIdentifier
implements Serializable {
    private static final int ANY_ATTEMPT = -1;
    private final Uuid fTaskID;
    private final int fNumRetryAttempt;

    public TaskAttemptIdentifier(Uuid uuid, int n) {
        assert (uuid != null) : "taskID was null";
        assert (n >= 0) : "numRetryAttempt has to be non-negative (was " + n + ")";
        this.fTaskID = uuid;
        this.fNumRetryAttempt = n;
    }

    public TaskAttemptIdentifier(Uuid uuid) {
        assert (uuid != null) : "taskID was null";
        this.fTaskID = uuid;
        this.fNumRetryAttempt = -1;
    }

    public Uuid getTaskID() {
        return this.fTaskID;
    }

    public int getAttemptNum() {
        return this.fNumRetryAttempt;
    }

    public boolean isSameAttempt(TaskAttemptIdentifier taskAttemptIdentifier) {
        return taskAttemptIdentifier != null && (this.fNumRetryAttempt == -1 || taskAttemptIdentifier.fNumRetryAttempt == -1 || this.fNumRetryAttempt == taskAttemptIdentifier.fNumRetryAttempt);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TaskAttemptIdentifier)) {
            return false;
        }
        TaskAttemptIdentifier taskAttemptIdentifier = (TaskAttemptIdentifier)object;
        return this.fTaskID.equals((Object)taskAttemptIdentifier.fTaskID) && this.isSameAttempt(taskAttemptIdentifier);
    }

    public int hashCode() {
        return this.fNumRetryAttempt == -1 ? this.fTaskID.hashCode() : this.fTaskID.hashCode() ^ this.fNumRetryAttempt;
    }

    public String toString() {
        return this.fNumRetryAttempt == -1 ? "(any attempt)" : "(attempt: " + this.fNumRetryAttempt + ")";
    }
}

