/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import com.sun.jini.phoenix.AbstractSystem;
import com.sun.jini.phoenix.ActivationAdmin;
import com.sun.jini.phoenix.DefaultGroupPolicy;
import com.sun.jini.phoenix.GroupPolicy;
import com.sun.jini.phoenix.LocalAccess;
import com.sun.jini.phoenix.SunJrmpExporter;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.server.ExportException;
import java.util.Map;
import net.jini.export.Exporter;

public class SystemAccessExporter
implements Exporter {
    private final Exporter exporter;
    private final GroupPolicy policy;
    private Remote wrapped;

    public SystemAccessExporter() {
        this(1098);
    }

    public SystemAccessExporter(GroupPolicy groupPolicy) {
        this(1098, groupPolicy);
    }

    public SystemAccessExporter(int n) {
        this(n, (GroupPolicy)new DefaultGroupPolicy());
    }

    public SystemAccessExporter(int n, GroupPolicy groupPolicy) {
        this(new SunJrmpExporter(4, n), groupPolicy);
    }

    public SystemAccessExporter(Exporter exporter) {
        this(exporter, (GroupPolicy)new DefaultGroupPolicy());
    }

    public SystemAccessExporter(Exporter exporter, GroupPolicy groupPolicy) {
        this.exporter = exporter;
        this.policy = groupPolicy;
    }

    public Remote export(Remote remote) throws ExportException {
        if (!(remote instanceof ActivationSystem)) {
            throw new IllegalArgumentException("not an ActivationSystem");
        }
        if (!(remote instanceof ActivationAdmin)) {
            throw new IllegalArgumentException("not an ActivationAdmin");
        }
        SystemImpl systemImpl = new SystemImpl((ActivationSystem)remote, this.policy);
        Remote remote2 = this.exporter.export(systemImpl);
        this.wrapped = systemImpl;
        return remote2;
    }

    public boolean unexport(boolean bl) {
        return this.exporter.unexport(bl);
    }

    private static class SystemImpl
    extends AbstractSystem {
        private final ActivationSystem impl;
        private final GroupPolicy policy;

        SystemImpl(ActivationSystem activationSystem, GroupPolicy groupPolicy) {
            this.impl = activationSystem;
            this.policy = groupPolicy;
        }

        public ActivationID registerObject(ActivationDesc activationDesc) throws ActivationException, RemoteException {
            LocalAccess.check();
            return this.impl.registerObject(activationDesc);
        }

        public void unregisterObject(ActivationID activationID) throws ActivationException, RemoteException {
            LocalAccess.check();
            this.impl.unregisterObject(activationID);
        }

        public ActivationGroupID registerGroup(ActivationGroupDesc activationGroupDesc) throws ActivationException, RemoteException {
            LocalAccess.check();
            if (this.policy != null) {
                this.policy.checkGroup(activationGroupDesc);
            }
            return this.impl.registerGroup(activationGroupDesc);
        }

        public ActivationMonitor activeGroup(ActivationGroupID activationGroupID, ActivationInstantiator activationInstantiator, long l) throws ActivationException, RemoteException {
            LocalAccess.check();
            return this.impl.activeGroup(activationGroupID, activationInstantiator, l);
        }

        public void unregisterGroup(ActivationGroupID activationGroupID) throws ActivationException, RemoteException {
            LocalAccess.check();
            this.impl.unregisterGroup(activationGroupID);
        }

        public ActivationDesc setActivationDesc(ActivationID activationID, ActivationDesc activationDesc) throws ActivationException, RemoteException {
            LocalAccess.check();
            return this.impl.setActivationDesc(activationID, activationDesc);
        }

        public ActivationGroupDesc setActivationGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) throws ActivationException, RemoteException {
            LocalAccess.check();
            if (this.policy != null) {
                this.policy.checkGroup(activationGroupDesc);
            }
            return this.impl.setActivationGroupDesc(activationGroupID, activationGroupDesc);
        }

        public ActivationDesc getActivationDesc(ActivationID activationID) throws ActivationException, RemoteException {
            LocalAccess.check();
            return this.impl.getActivationDesc(activationID);
        }

        public ActivationGroupDesc getActivationGroupDesc(ActivationGroupID activationGroupID) throws ActivationException, RemoteException {
            LocalAccess.check();
            return this.impl.getActivationGroupDesc(activationGroupID);
        }

        public void shutdown() throws RemoteException {
            LocalAccess.check();
            this.impl.shutdown();
        }

        public Map getActivationGroups() throws RemoteException {
            LocalAccess.check();
            return ((ActivationAdmin)this.impl).getActivationGroups();
        }

        public Map getActivatableObjects(ActivationGroupID activationGroupID) throws UnknownGroupException, RemoteException {
            LocalAccess.check();
            return ((ActivationAdmin)this.impl).getActivatableObjects(activationGroupID);
        }
    }
}

