/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.CategoryUtils;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.search.SearchResult;
import com.mathworks.search.facet.FacetFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CategoryFacetFilter
implements FacetFilter<ResultCategory> {
    private final String fParentId;
    private final Map<String, ResultCategory> fComponentCache = new HashMap<String, ResultCategory>();
    private final Pattern fIdPattern;
    private ResultCategory fAncestor;

    public CategoryFacetFilter() {
        this(null);
    }

    public CategoryFacetFilter(String parentId) {
        this.fParentId = parentId;
        this.fIdPattern = CategoryUtils.buildIdFromIndexStringPattern(parentId);
    }

    public Collection<ResultCategory> determineFacet(SearchResult result) {
        String ignore = result.getFieldValue(DocumentationSearchField.UNFACETED_CATEGORY.getFieldName());
        if (ignore != null && ignore.equals("1")) {
            return Collections.emptyList();
        }
        if (this.fParentId != null && this.fAncestor == null) {
            this.fAncestor = CategoryFacetFilter.getResultCategoryForId(this.fParentId, result);
        }
        String ancestorIds = result.getFieldValue(DocumentationSearchField.ANCESTOR_ID.getFieldName());
        String[] childIds = this.getChildIds(ancestorIds);
        ArrayList<ResultCategory> categories = new ArrayList<ResultCategory>();
        for (String childId : childIds) {
            ResultCategory cat = this.getComponent(childId, result);
            if (cat == null) continue;
            categories.add(cat);
        }
        return categories;
    }

    private ResultCategory getComponent(String nodeId, SearchResult result) {
        if (nodeId != null && nodeId.trim().length() > 0) {
            ResultCategory comp = this.fComponentCache.get(nodeId);
            if (comp == null && (comp = CategoryFacetFilter.getResultCategoryForId(nodeId, result)) != null) {
                this.fComponentCache.put(nodeId, comp);
            }
            return comp;
        }
        return null;
    }

    private static ResultCategory getResultCategoryForId(String nodeId, SearchResult result) {
        String breadCrumbString = result.getFieldValue(DocumentationSearchField.ANCESTOR_LABEL.getFieldName());
        if (nodeId.equals(result.getFieldValue(DocumentationSearchField.NODE_ID.getFieldName()))) {
            List<ResultCategory> breadCrumbs = CategoryUtils.parseSearchIndexString(breadCrumbString);
            ResultCategory parentCategory = breadCrumbs.isEmpty() ? null : breadCrumbs.get(0);
            String title = result.getFieldValue(DocumentationSearchField.TITLE_DISPLAY.getFieldName());
            String relPath = result.getFieldValue(DocumentationSearchField.RELATIVE_PATH.getFieldName());
            return new ResultCategory(parentCategory, title, relPath, nodeId);
        }
        return CategoryUtils.getSingleCategoryFromIndexString(breadCrumbString, nodeId);
    }

    public ResultCategory getAncestor() {
        return this.fAncestor;
    }

    String[] getChildIds(String indexIdString) {
        Matcher m = this.fIdPattern.matcher(indexIdString);
        HashSet<String> ids = new HashSet<String>();
        while (m.find()) {
            ids.add(m.group(1));
        }
        return ids.toArray(new String[ids.size()]);
    }
}

