/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.InformationType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum ContentFormat {
    CLASSIC_DOC(InformationType.FUNCTIONS, InformationType.BLOCKS, InformationType.RELEASE_NOTES, InformationType.USER_GUIDE),
    DOC_CENTER_DOC(InformationType.FUNCTIONS, InformationType.SYSTEM_OBJECTS, InformationType.BLOCKS, InformationType.CATEGORY_PAGE, InformationType.EXAMPLES_HOWTO, InformationType.MORE_ABOUT, InformationType.RELEASE_NOTES);

    private final List<InformationType> fAllInfoTypes;
    private final Map<String, InformationType> fTypesByIndexString = new HashMap<String, InformationType>();

    private ContentFormat(InformationType ... types) {
        this.fAllInfoTypes = Arrays.asList(types);
        for (InformationType type : types) {
            this.fTypesByIndexString.put(type.getIndexString(), type);
        }
    }

    public List<InformationType> getInformationTypes() {
        return Collections.unmodifiableList(this.fAllInfoTypes);
    }

    public InformationType getInfoTypeByIndexString(String indexString) {
        return indexString == null || indexString.length() == 0 ? null : this.fTypesByIndexString.get(indexString);
    }
}

