/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.search.SearchLanguage;
import java.util.Locale;

public enum DocLanguage {
    ENGLISH("en", new Locale("en", "US"), SearchLanguage.ENGLISH),
    JAPANESE("ja_JP", new Locale("ja", "JP"), SearchLanguage.JAPANESE),
    SIMPLIFIED_CHINESE("zh_CN", new Locale("zh", "CN"), SearchLanguage.SIMPLIFIED_CHINESE);

    private final String fDirectory;
    private final Locale fLocale;
    private final SearchLanguage fSearchLanguage;

    private DocLanguage(String directory, Locale locale, SearchLanguage searchLanguage) {
        this.fDirectory = directory;
        this.fLocale = locale;
        this.fSearchLanguage = searchLanguage;
    }

    public String getDirectory() {
        return this.fDirectory;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public SearchLanguage getSearchLanguage() {
        return this.fSearchLanguage;
    }

    public static DocLanguage fromDirectory(String directory) {
        for (DocLanguage lang : DocLanguage.values()) {
            if (!lang.fDirectory.equals(directory)) continue;
            return lang;
        }
        return null;
    }

    public static DocLanguage getDefault() {
        return ENGLISH;
    }
}

