/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.DocumentationAnalyzer;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.SearchDirectory;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.lucene.FileSystemIndexLocation;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneSearchEngine;
import java.io.File;
import java.util.EnumSet;
import org.apache.lucene.analysis.Analyzer;

public class DocSearchEngineFactory {
    public static SearchEngine createSearchEngine(SearchConfig config, DocumentationSet docSet) {
        SearchDirectory directory = new SearchDirectory(config);
        if (directory.isLocked()) {
            return null;
        }
        File indexDir = directory.getIndexDir();
        FileSystemIndexLocation location = new FileSystemIndexLocation(indexDir, false);
        EnumSet<DocumentationSearchField> fields = EnumSet.of(DocumentationSearchField.BODY, DocumentationSearchField.TITLE_SEARCH, DocumentationSearchField.SUMMARY);
        DocumentationAnalyzer docCenterAnalyzer = DocumentationAnalyzer.getSearchAnalyzer(docSet.getLanguage().getSearchLanguage());
        return new LuceneSearchEngine((Analyzer)docCenterAnalyzer, fields, new IndexLocation[]{location});
    }
}

