/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.search.SearchLanguage;
import com.mathworks.search.lucene.MWAnalyzer;
import java.io.Reader;
import java.util.EnumMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharTokenizer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;

public class DocumentationAnalyzer
extends Analyzer {
    private static final Map<SearchLanguage, DocumentationAnalyzer> INDEX_ANALYZERS = DocumentationAnalyzer.buildIndexAnalyzers();
    private static final Map<SearchLanguage, DocumentationAnalyzer> SEARCH_ANALYZERS = DocumentationAnalyzer.buildSearchAnalyzers();
    private final Analyzer fBaseAnalyzer;

    private static Map<SearchLanguage, DocumentationAnalyzer> buildIndexAnalyzers() {
        EnumMap<SearchLanguage, DocumentationAnalyzer> analyzers = new EnumMap<SearchLanguage, DocumentationAnalyzer>(SearchLanguage.class);
        for (SearchLanguage language : SearchLanguage.values()) {
            analyzers.put(language, new DocumentationAnalyzer(new MWAnalyzer(language).getIndexAnalyzer()));
        }
        return analyzers;
    }

    private static Map<SearchLanguage, DocumentationAnalyzer> buildSearchAnalyzers() {
        EnumMap<SearchLanguage, DocumentationAnalyzer> analyzers = new EnumMap<SearchLanguage, DocumentationAnalyzer>(SearchLanguage.class);
        for (SearchLanguage language : SearchLanguage.values()) {
            analyzers.put(language, new DocumentationAnalyzer(new MWAnalyzer(language).getSearchAnalyzer()));
        }
        return analyzers;
    }

    private DocumentationAnalyzer(Analyzer baseAnalyzer) {
        this.fBaseAnalyzer = baseAnalyzer;
    }

    public static DocumentationAnalyzer getIndexAnalyzer(SearchLanguage language) {
        return INDEX_ANALYZERS.get(language);
    }

    public static DocumentationAnalyzer getSearchAnalyzer(SearchLanguage language) {
        return SEARCH_ANALYZERS.get(language);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream nonStandardStream = DocumentationAnalyzer.getNonStandardTokenStream(fieldName, reader);
        return nonStandardStream == null ? this.fBaseAnalyzer.tokenStream(fieldName, reader) : nonStandardStream;
    }

    private static TokenStream getNonStandardTokenStream(String fieldName, Reader reader) {
        DocumentationSearchField searchField = DocumentationSearchField.fromFieldName(fieldName);
        if (searchField != null) {
            switch (searchField) {
                case REFPAGE_ENTITY_INFO: 
                case REFPAGE_ENTITY_NAME: {
                    return new LowerCaseFilter((TokenStream)new NewlineTokenizer(reader));
                }
                case REFPAGE_ENTITY_INFO_CASE: 
                case REFPAGE_ENTITY_NAME_CASE: 
                case REFPAGE_ENTITY_TYPE: {
                    return new NewlineTokenizer(reader);
                }
                case ANCESTOR_ID: {
                    return new WhitespaceTokenizer(reader);
                }
            }
        }
        return null;
    }

    private static class NewlineTokenizer
    extends CharTokenizer {
        public NewlineTokenizer(Reader reader) {
            super(reader);
        }

        protected boolean isTokenChar(char c) {
            return c != '\n';
        }
    }
}

