/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.SearchHighlight;
import com.mathworks.helpsearch.SearchKeywordsVisitor;
import com.mathworks.search.ExactPhraseSearchExpression;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HighlightProvider {
    private final int fMaxChars;
    private static final String BEFORE_MATCH = "(?<=[^\\p{L}\\d]|^)";
    private static final String AFTER_MATCH = "(?=[^\\p{L}\\d]|$)";
    private final Pattern fFullSentencePattern;
    private final Pattern fSingleLinePattern;
    private final Pattern fMultiLinePattern;
    private final Pattern fKeywordsPattern;

    public HighlightProvider(SearchExpression expr, int maxChars) {
        Collection<String> keywords;
        this.fMaxChars = maxChars;
        SearchKeywordsVisitor skv = new SearchKeywordsVisitor();
        try {
            expr.accept((SearchVisitor)skv);
            keywords = skv.getSearchKeywords();
        }
        catch (Exception e) {
            keywords = Collections.emptyList();
        }
        String looseRegexp = HighlightProvider.createKeywordsRegexp(keywords, true);
        this.fKeywordsPattern = Pattern.compile(looseRegexp, 2);
        String strictRegexp = HighlightProvider.createKeywordsRegexp(keywords, false);
        this.fFullSentencePattern = HighlightProvider.createFullSentencePattern(strictRegexp);
        this.fSingleLinePattern = HighlightProvider.createPartialSentenceHighlightPattern(strictRegexp);
        this.fMultiLinePattern = expr instanceof ExactPhraseSearchExpression ? HighlightProvider.createLooseHighlightPattern(looseRegexp) : null;
    }

    public List<SearchHighlight> getHighlights(String textToHighlight) {
        HighlightCollector collector = new HighlightCollector(textToHighlight);
        return collector.findHighlights();
    }

    private static String createKeywordsRegexp(Collection<String> keywords, boolean crossNewLine) {
        boolean requireWordBreaks = HighlightProvider.requireWordBreaks(keywords);
        StringBuilder builder = new StringBuilder();
        if (requireWordBreaks) {
            builder.append(BEFORE_MATCH);
        }
        if (!keywords.isEmpty()) {
            builder.append('(');
            for (String keyword : keywords) {
                builder.append(HighlightProvider.createRegexpForKeyword(keyword, crossNewLine)).append('|');
            }
            builder.delete(builder.length() - 1, builder.length());
            builder.append(')');
        } else {
            builder.append(".*");
        }
        if (requireWordBreaks) {
            builder.append(AFTER_MATCH);
        }
        return builder.toString();
    }

    private static boolean requireWordBreaks(Collection<String> keywords) {
        for (String keyword : keywords) {
            if (!HighlightProvider.containsNonAscii(keyword)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsNonAscii(String keyword) {
        for (char c : keyword.toCharArray()) {
            if (c <= '\u007f') continue;
            return true;
        }
        return false;
    }

    static String createRegexpForKeyword(String keyword, boolean crossNewLine) {
        StringBuilder regexp = new StringBuilder();
        Pattern regexpSplitter = Pattern.compile("(\\*|\\s+)");
        Matcher m = regexpSplitter.matcher(keyword);
        int start = 0;
        while (m.find()) {
            String keywordSubstr = keyword.substring(start, m.end() - 1);
            if (keywordSubstr.length() > 0) {
                regexp.append(Pattern.quote(keywordSubstr));
                if (m.group().matches("\\*")) {
                    regexp.append("\\w*");
                } else if (m.group().matches("\\s+")) {
                    if (crossNewLine) {
                        regexp.append("[\\W_]+");
                    } else {
                        regexp.append("([^\\w\\n]|_)+");
                    }
                }
            }
            start = m.end();
        }
        if (keyword.substring(start).length() > 0) {
            regexp.append(Pattern.quote(keyword.substring(start)));
        }
        return regexp.toString();
    }

    private static Pattern createFullSentencePattern(String keywordsRegexp) {
        return Pattern.compile("^.*" + keywordsRegexp + ".*\\.$", 10);
    }

    private static Pattern createPartialSentenceHighlightPattern(String keywordsRegexp) {
        return Pattern.compile("^.*" + keywordsRegexp + ".*$(?<!\\.)", 10);
    }

    private static Pattern createLooseHighlightPattern(String keywordsRegexp) {
        return Pattern.compile("^.*" + keywordsRegexp + ".*$", 10);
    }

    static /* synthetic */ int access$200(HighlightProvider x0) {
        return x0.fMaxChars;
    }

    private static interface HighlightFilter {
        public boolean acceptHighlight(SearchHighlight var1);
    }

    private static class MultiLinkHighlightFiler
    implements HighlightFilter {
        private MultiLinkHighlightFiler() {
        }

        @Override
        public boolean acceptHighlight(SearchHighlight highlight) {
            return highlight.getOriginalText().contains("\n");
        }
    }

    private class HighlightCollector {
        private final String fTextToHighlight;
        private final List<SearchHighlight> iHighlights = new ArrayList<SearchHighlight>();
        private int iRemainingChars = HighlightProvider.access$200(HighlightProvider.this);

        private HighlightCollector(String textToHighlight) {
            this.fTextToHighlight = textToHighlight;
        }

        private List<SearchHighlight> findHighlights() {
            this.findHighlightsForPattern(HighlightProvider.this.fFullSentencePattern, null);
            if (this.iRemainingChars > 0) {
                this.findHighlightsForPattern(HighlightProvider.this.fSingleLinePattern, null);
            }
            if (this.iRemainingChars > 0 && HighlightProvider.this.fMultiLinePattern != null) {
                this.findHighlightsForPattern(HighlightProvider.this.fMultiLinePattern, new MultiLinkHighlightFiler());
            }
            return this.iHighlights;
        }

        private void findHighlightsForPattern(Pattern pattern, HighlightFilter filter) {
            Matcher matcher = pattern.matcher(this.fTextToHighlight);
            while (this.iRemainingChars > 0 && matcher.find()) {
                String highlightText = matcher.group();
                if (!this.iHighlights.isEmpty() && (highlightText = this.trimHighlightText(matcher.group())) == null) continue;
                SearchHighlight highlight = new SearchHighlight(highlightText);
                Matcher keywordsMatcher = HighlightProvider.this.fKeywordsPattern.matcher(highlightText);
                while (keywordsMatcher.find()) {
                    if (keywordsMatcher.groupCount() <= 0) continue;
                    highlight.addExtent(keywordsMatcher.start(1), keywordsMatcher.end(1));
                }
                if (filter != null && !filter.acceptHighlight(highlight)) continue;
                this.iHighlights.add(highlight);
                this.iRemainingChars -= highlight.getHighlightText().length();
            }
        }

        private String trimHighlightText(String highlightText) {
            if (highlightText.length() > this.iRemainingChars) {
                String trimmed;
                Pattern p = Pattern.compile("^.{0," + this.iRemainingChars + "}\\w\\b");
                Matcher m = p.matcher(highlightText);
                if (m.find() && (trimmed = m.group()).length() * 2 > highlightText.length()) {
                    return trimmed;
                }
                return null;
            }
            return highlightText;
        }
    }
}

