/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.facets;

import com.mathworks.helpsearch.CategoryFacetFilter;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.facets.CategoryLabelRetriever;
import com.mathworks.helpsearch.facets.FacetSearchHelper;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchResult;
import com.mathworks.search.facet.FacetFilter;
import com.mathworks.search.facet.FacetResult;
import com.mathworks.search.facet.FacetResultCollector;
import com.mathworks.search.facet.SimpleFacetResultCollector;
import java.util.List;

public class CategoryFacetCollector
implements FacetResultCollector<ResultCategory> {
    private final FacetSearchHelper<ResultCategory> fHelper;
    private final CategoryFacetFilter fFilter;
    private final FacetResultCollector<ResultCategory> fBaseCollector;
    private final String fSelectedCategory;
    private final CategoryLabelRetriever fLabelRetriever;

    public CategoryFacetCollector(FacetSearchHelper<ResultCategory> helper, String selectedCategory, CategoryLabelRetriever labelRetriever) {
        this.fHelper = helper;
        this.fSelectedCategory = selectedCategory;
        this.fLabelRetriever = labelRetriever;
        this.fFilter = new CategoryFacetFilter(selectedCategory);
        this.fBaseCollector = SimpleFacetResultCollector.createSortByResultCountCollector((FacetFilter)this.fFilter);
    }

    public List<FacetResult<ResultCategory>> getResults() {
        return this.fBaseCollector.getResults();
    }

    public void examineResult(SearchResult result) throws SearchException {
        this.fBaseCollector.examineResult(result);
    }

    public void resultsComplete() {
        this.fBaseCollector.resultsComplete();
        this.fHelper.setSelectedFacet(this.getSelectedCategory());
    }

    private ResultCategory getSelectedCategory() {
        ResultCategory selected = this.fFilter.getAncestor();
        if (selected == null && this.fSelectedCategory != null) {
            String label = this.fLabelRetriever.getFacetLabel(this.fSelectedCategory);
            selected = new ResultCategory(null, label, null, this.fSelectedCategory);
        }
        return selected;
    }
}

