/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.index.DocTraversalStrategy;
import com.mathworks.helpsearch.index.DocumentationDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class DocCrawler
implements DocTraversalStrategy {
    private static final String LANDING_PAGE = "index.html";
    private final Set<String> fVisitedDocs = new HashSet<String>();
    private boolean fLandingPageVisited = false;

    @Override
    public Collection<String> updateAfterDocument(DocumentationDocument lastDocument, boolean indexed) {
        String relPath = lastDocument.getRelativePath();
        this.fVisitedDocs.add(relPath);
        if (indexed) {
            LinkedList<String> newDocs = new LinkedList<String>();
            for (String link : lastDocument.getOutgoingLinks()) {
                if (link.contains("//") || this.fVisitedDocs.contains(link)) continue;
                newDocs.add(link);
            }
            return newDocs;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getPendingDocuments() {
        if (!this.fLandingPageVisited) {
            this.fLandingPageVisited = true;
            ArrayList<String> docs = new ArrayList<String>(1);
            docs.add(LANDING_PAGE);
            return docs;
        }
        return Collections.emptyList();
    }
}

