/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.index.IndexerConfig;
import com.mathworks.helpsearch.index.LinkResolver;
import com.mathworks.helpsearch.product.DocProduct;
import java.io.File;

public class ProductLinkResolver
implements LinkResolver {
    private final File fHelpLoc;

    public ProductLinkResolver(IndexerConfig config, DocProduct product) {
        this.fHelpLoc = config == null ? null : ProductLinkResolver.makeCanonical(config.getHelpLocation(product));
    }

    @Override
    public String resolveLink(String fromRelPath, String toRelPath) {
        File fromDir = new File(this.fHelpLoc, fromRelPath).getParentFile();
        File toFile = ProductLinkResolver.makeCanonical(new File(fromDir, toRelPath));
        return this.getRelativePathFromProduct(toFile);
    }

    private static File makeCanonical(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (Exception e) {
            return file;
        }
    }

    private String getRelativePathFromProduct(File file) {
        StringBuilder relPath = new StringBuilder();
        for (File current = file; current != null; current = current.getParentFile()) {
            if (current.equals(this.fHelpLoc)) {
                return relPath.toString();
            }
            if (relPath.length() > 0) {
                relPath.insert(0, "/");
            }
            relPath.insert(0, current.getName());
        }
        return null;
    }
}

