/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.doccenter;

import com.mathworks.helpsearch.index.DocumentBody;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.XmlFragmentHandler;
import com.mathworks.helpsearch.index.XmlFragmentReader;
import com.mathworks.helpsearch.index.XmlTagInfo;
import com.mathworks.helpsearch.index.doccenter.DocCenterHtmlTagUtils;
import java.util.Locale;

class BodyFragmentHandler
implements XmlFragmentHandler,
XmlFragmentReader {
    private final DocumentBody fBody = new DocumentBody();
    private boolean fInSeeAlso = false;
    private XmlTagInfo fInactiveTag = null;

    BodyFragmentHandler() {
    }

    @Override
    public String[] getEnclosingTagNames() {
        return new String[]{"div", "section"};
    }

    @Override
    public boolean useHandler(XmlTagInfo xmlTag) {
        return DocCenterHtmlTagUtils.isContentContainerTag(xmlTag);
    }

    @Override
    public boolean continueHandling() {
        return false;
    }

    @Override
    public void startElement(XmlTagInfo tagInfo) {
        if (BodyFragmentHandler.isDocSearchContainer(tagInfo)) {
            this.fInactiveTag = tagInfo;
        }
        this.fBody.appendTagReplacement(tagInfo.getTagName());
    }

    private static boolean isDocSearchContainer(XmlTagInfo tagInfo) {
        if (tagInfo.getTagName().equals("div")) {
            String htmlClass = tagInfo.getAttribute("class");
            return htmlClass != null && htmlClass.equals("docsearch_container");
        }
        return false;
    }

    @Override
    public void characters(XmlTagInfo location, String chars) {
        if (location.getTagName().toLowerCase(Locale.ENGLISH).matches("h\\d")) {
            this.fInSeeAlso = chars.trim().equalsIgnoreCase("see also");
        }
        if (this.isContentIncluded(location)) {
            this.fBody.append(chars);
        }
    }

    private boolean isContentIncluded(XmlTagInfo tagInfo) {
        return this.fInactiveTag == null && !this.fInSeeAlso && !tagInfo.isWithinTag("script");
    }

    @Override
    public void endElement(XmlTagInfo location) {
        if (location.equals(this.fInactiveTag)) {
            this.fInactiveTag = null;
        }
        this.fBody.appendTagReplacement(location.getTagName());
    }

    @Override
    public XmlFragmentReader startFragment(XmlTagInfo location) {
        return this;
    }

    @Override
    public void endFragment(XmlTagInfo location) {
    }

    @Override
    public void populateDocument(DocumentationDocument doc) {
        if (doc.getBody() == null) {
            doc.setBody(this.fBody.getBody());
        }
    }
}

