/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.product.BaseCodeMapBuilder;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetParser;
import com.mathworks.helpsearch.product.ProductBaseCodeMap;
import com.mathworks.helpsearch.product.PropertiesBaseCodeMapBuilder;
import com.mathworks.helpsearch.product.SimpleDocProduct;
import com.mathworks.helpsearch.product.SimpleDocumentationSet;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JavaScriptBaseCodeMap {
    private static final String CONSTRUCTOR = "function BaseCodeMap() {\n";
    private static final String VAR_ASSIGNMENT = "    this.";
    private static final String CLOSE_BRACE = "}";
    private final ProductBaseCodeMap fBaseCodeMap;

    public JavaScriptBaseCodeMap(ProductBaseCodeMap baseCodeMap) {
        this.fBaseCodeMap = baseCodeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJsFile(File location) throws IOException {
        location = this.prepareJsFile(location);
        String script = this.getBaseCodeMapFunction();
        FileWriter writer = new FileWriter(location);
        try {
            writer.write(script);
        }
        finally {
            writer.close();
        }
    }

    private File prepareJsFile(File location) {
        if (location.exists() && location.isDirectory()) {
            location = new File(location, "basecode.js");
        }
        if (location.exists()) {
            location.delete();
        }
        return location;
    }

    public String getBaseCodeMapFunction() {
        StringBuilder js = new StringBuilder(CONSTRUCTOR);
        js.append(VAR_ASSIGNMENT).append("global = ").append(this.getGlobalProductsArray()).append(";\n");
        js.append(VAR_ASSIGNMENT).append("simple = ").append(this.getSimpleMap()).append(";\n");
        js.append(VAR_ASSIGNMENT).append("multi = ").append(this.getMultiProductMap()).append(";\n");
        js.append(CLOSE_BRACE);
        return js.toString();
    }

    private String getGlobalProductsArray() {
        List<DocProduct> globalProducts = this.fBaseCodeMap.getGlobalProducts();
        if (globalProducts != null && !globalProducts.isEmpty()) {
            return JavaScriptBaseCodeMap.getProductsArray(globalProducts);
        }
        return "[]";
    }

    private String getSimpleMap() {
        Map<String, List<DocProduct>> simpleMappings = this.fBaseCodeMap.getSimpleMappings();
        if (simpleMappings != null && !simpleMappings.isEmpty()) {
            StringBuilder jsObject = new StringBuilder("{");
            for (Map.Entry<String, List<DocProduct>> entry : simpleMappings.entrySet()) {
                jsObject.append("\n        \"").append(entry.getKey()).append("\":");
                jsObject.append(JavaScriptBaseCodeMap.getProductsArray(entry.getValue())).append(',');
            }
            jsObject.deleteCharAt(jsObject.length() - 1);
            jsObject.append("\n    }");
            return jsObject.toString();
        }
        return "{}";
    }

    private String getMultiProductMap() {
        List<ProductBaseCodeMap.MultiBaseCodeMapping> multiMappings = this.fBaseCodeMap.getMultiBaseCodeMappings();
        if (multiMappings != null && !multiMappings.isEmpty()) {
            StringBuilder jsObject = new StringBuilder("{");
            for (ProductBaseCodeMap.MultiBaseCodeMapping mapping : multiMappings) {
                jsObject.append("\n        ").append(JavaScriptBaseCodeMap.getMultiProductMapEntry(mapping)).append(',');
            }
            jsObject.deleteCharAt(jsObject.length() - 1);
            jsObject.append("\n    }");
            return jsObject.toString();
        }
        return "{}";
    }

    private static String getMultiProductMapEntry(ProductBaseCodeMap.MultiBaseCodeMapping mapping) {
        StringBuilder jsMapping = new StringBuilder("\"");
        jsMapping.append(mapping.getProduct().getShortName()).append("\":");
        jsMapping.append(JavaScriptBaseCodeMap.toJavaScriptArray(mapping.getBaseCodes()));
        return jsMapping.toString();
    }

    private static String getProductsArray(List<DocProduct> products) {
        LinkedList<String> shortNames = new LinkedList<String>();
        for (DocProduct product : products) {
            shortNames.add(product.getShortName());
        }
        return JavaScriptBaseCodeMap.toJavaScriptArray(shortNames);
    }

    private static String toJavaScriptArray(List<String> values) {
        StringBuilder jsArray = new StringBuilder();
        for (String entry : values) {
            jsArray.append(",\"").append(entry).append('\"');
        }
        jsArray.append(']');
        jsArray.setCharAt(0, '[');
        return jsArray.toString();
    }

    public static void main(String[] args) {
        String helpDir = args[0];
        final String docSetDir = args[1];
        File baseCodesFile = new File(docSetDir, "basecodes.properties");
        try {
            PropertiesBaseCodeMapBuilder mapBuilder = new PropertiesBaseCodeMapBuilder(baseCodesFile);
            DocSetParser<SimpleDocumentationSet> parser = new DocSetParser<SimpleDocumentationSet>((BaseCodeMapBuilder)mapBuilder){

                @Override
                protected File getDocSetConfigFile() {
                    return new File(docSetDir, "docset.xml");
                }

                @Override
                protected SimpleDocumentationSet createNewDocSet(ContentFormat format) {
                    return new SimpleDocumentationSet(ContentFormat.DOC_CENTER_DOC, DocLanguage.ENGLISH);
                }

                @Override
                protected DocProduct createNewProduct(SimpleDocumentationSet docSet, String shortName, String displayName, String helpLoc) {
                    return new SimpleDocProduct(docSet, shortName, displayName, helpLoc);
                }
            };
            Object docSet = parser.getDocSet();
            JavaScriptBaseCodeMap jsMap = new JavaScriptBaseCodeMap(docSet.getBaseCodeMap());
            jsMap.writeJsFile(new File(helpDir));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

