/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product;

import com.mathworks.helpsearch.product.DocProduct;
import java.util.Comparator;

public class ProductNameComparator
implements Comparator<DocProduct> {
    private static final String MATLAB_SHORT_NAME = "matlab";
    private static final String SIMULINK_SHORT_NAME = "simulink";

    @Override
    public int compare(DocProduct prod1, DocProduct prod2) {
        SortPriority priority1 = ProductNameComparator.getSortPriority(prod1);
        SortPriority priority2 = ProductNameComparator.getSortPriority(prod2);
        if (priority1 == SortPriority.ALPHABETICAL && priority2 == SortPriority.ALPHABETICAL) {
            return prod1.getDisplayName().compareTo(prod2.getDisplayName());
        }
        return priority1.compareTo(priority2);
    }

    private static SortPriority getSortPriority(DocProduct product) {
        String shortName = product.getShortName();
        if (shortName.equals(MATLAB_SHORT_NAME)) {
            return SortPriority.MATLAB;
        }
        if (shortName.equals(SIMULINK_SHORT_NAME)) {
            return SortPriority.SIMULINK;
        }
        return SortPriority.ALPHABETICAL;
    }

    private static enum SortPriority {
        MATLAB,
        SIMULINK,
        ALPHABETICAL;

    }
}

