/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product.validation;

import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.ProductBaseCodeMap;
import com.mathworks.helpsearch.product.validation.DocSetValidationCheck;
import com.mathworks.helpsearch.product.validation.DocSetValidationResponse;
import java.util.HashSet;

public class BaseCodeMappingCheck
implements DocSetValidationCheck {
    @Override
    public DocSetValidationResponse validate(DocumentationSet docSet) {
        DocSetValidationResponse response = new DocSetValidationResponse();
        ProductBaseCodeMap map = docSet.getBaseCodeMap();
        if (map == null) {
            response.addMessage(DocSetValidationResponse.Status.ERROR, "No base code to product mapping found.");
            return response;
        }
        HashSet<DocProduct> mappedProducts = new HashSet<DocProduct>(map.getAllKnownProducts());
        mappedProducts.removeAll(docSet.getAllProducts());
        if (!mappedProducts.isEmpty()) {
            for (DocProduct unknownProduct : mappedProducts) {
                response.addMessage(DocSetValidationResponse.Status.WARNING, "Base code mapping for unknown product \"" + unknownProduct.getDisplayName() + "\": " + map.getProductRequirementsString(unknownProduct));
            }
        }
        for (DocProduct product : docSet.getAllProducts()) {
            if (map.getProductRequirementsString(product) == null) {
                response.addMessage(DocSetValidationResponse.Status.ERROR, product.getDisplayName() + " has no base code mapping.");
                continue;
            }
            response.addMessage(DocSetValidationResponse.Status.OK, product.getDisplayName() + " : " + map.getProductRequirementsString(product));
        }
        if (response.getSeverity() == DocSetValidationResponse.Status.ERROR) {
            response.addTroubleshootingStep("This error typically means that products were added to or changed in the documentation set configuration without a corresponding update to the documentation set's base code mappings.  The solution is typically to update the base code mappings.");
        }
        return response;
    }

    @Override
    public String getName() {
        return "Base Codes";
    }

    @Override
    public String getDescription() {
        return "Validates that each product has a base code mapping.  For \"global\" products such as installation or release notes, this simply means that the product has been explicitly listed as having no base code dependency - this check validates that there are no products that have no base code mapping of any kind.";
    }
}

