/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum RefEntityType {
    FUNCTION("function"),
    BLOCK("block"),
    MODEL("model"),
    CLASS("class"),
    METHOD("method"),
    PROPERTY("property"),
    EVENT("event"),
    SYSTEM_OBJECT("sysobj"),
    MUPAD_AXIOM("mupadaxiom"),
    MUPAD_CAT("mupadcat"),
    MUPAD_CONSTANT("mupadconstant"),
    MUPAD_DOMAIN("mupaddomain"),
    MUPAD_ENVVAR("mupadenvvar"),
    MUPAD_FUNCTION("mupadfunction"),
    MUPAD_GRAPH_ATTR("mupadgraphattr"),
    MUPAD_GRAPH_PRIM("mupadgraphprim"),
    MUPAD_KEYWORD("mupadkeyword");

    private static final Map<String, RefEntityType> LOOKUP_MAP;
    private String fRefPageMetaDataValue;

    private RefEntityType(String metaDataValue) {
        this.fRefPageMetaDataValue = metaDataValue;
    }

    public String getIndexValue() {
        return this.fRefPageMetaDataValue;
    }

    public static RefEntityType resolve(String entityName) {
        return LOOKUP_MAP.get(entityName.toLowerCase(Locale.ENGLISH));
    }

    public boolean isMupadType() {
        return this.toString().startsWith("MUPAD_");
    }

    static {
        LOOKUP_MAP = new HashMap<String, RefEntityType>();
        for (RefEntityType type : RefEntityType.values()) {
            LOOKUP_MAP.put(type.toString().toLowerCase(Locale.ENGLISH), type);
            LOOKUP_MAP.put(type.getIndexValue().toLowerCase(Locale.ENGLISH), type);
        }
    }
}

