/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class ClassLoaderUtil {
    static final Logger logger = Logger.getLogger("com.sun.jini.start.ClassLoaderUtil");

    public static URL[] getClasspathURLs(String string) throws MalformedURLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        URL[] uRLArray = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            uRLArray[n] = new File(stringTokenizer.nextToken()).toURL();
            ++n;
        }
        return uRLArray;
    }

    public static URL[] getCodebaseURLs(String string) throws MalformedURLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        URL[] uRLArray = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            uRLArray[n] = new URL(stringTokenizer.nextToken());
            ++n;
        }
        return uRLArray;
    }

    private static ArrayList getContextClassLoaderTree() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        return ClassLoaderUtil.getClassLoaderTree(classLoader);
    }

    private static ArrayList getClassLoaderTree(ClassLoader classLoader) {
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>();
        while (classLoader != null) {
            arrayList.add(classLoader);
            classLoader = classLoader.getParent();
        }
        arrayList.add(null);
        Collections.reverse(arrayList);
        return arrayList;
    }

    public static void displayContextClassLoaderTree() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        ClassLoaderUtil.displayClassLoaderTree(classLoader);
    }

    public static void displayClassLoaderTree(ClassLoader classLoader) {
        ArrayList arrayList = ClassLoaderUtil.getClassLoaderTree(classLoader);
        System.out.println("");
        System.out.println("ClassLoader Tree has " + arrayList.size() + " levels");
        System.out.println("  cl0 -- Boot ClassLoader ");
        ClassLoader classLoader2 = null;
        for (int i = 1; i < arrayList.size(); ++i) {
            System.out.println("   |");
            classLoader2 = (ClassLoader)arrayList.get(i);
            System.out.print("  cl" + i + " -- ClassLoader " + classLoader2 + ": ");
            if (classLoader2 instanceof URLClassLoader) {
                URL[] uRLArray = ((URLClassLoader)classLoader2).getURLs();
                if (uRLArray != null) {
                    System.out.print(uRLArray[0]);
                    for (int j = 1; j < uRLArray.length; ++j) {
                        System.out.print(", " + uRLArray[j]);
                    }
                } else {
                    System.out.print("null search path");
                }
            } else if (classLoader2 instanceof SecureClassLoader) {
                System.out.print("is instance of SecureClassLoader");
            } else {
                System.out.print("is unknown ClassLoader type");
            }
            System.out.println("");
        }
        System.out.println("");
    }
}

