/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl;

import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.mlwidgets.explorer.model.ExplorerExtensionRegistry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;

public class DocumentCellRenderer
extends DefaultListCellRenderer {
    private final String fEmptyNullText;
    private final String fNonEmptyNullText;
    private final Map<File, Icon> fCache;

    public DocumentCellRenderer() {
        this("", "");
    }

    public DocumentCellRenderer(String string, String string2) {
        this.fEmptyNullText = string;
        this.fNonEmptyNullText = string2;
        this.fCache = new HashMap<File, Icon>();
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (object == null || object instanceof File) {
            if (object != null) {
                File file = (File)object;
                String string = file.getName();
                if (this.isWide()) {
                    string = file.getAbsolutePath();
                }
                this.setText(string);
                Icon icon = this.fCache.get(file);
                if (icon == null) {
                    icon = UiFileSystemUtils.getIconEvenIfNonExistent((FileSystem)RealFileSystem.getInstance(), (FileLocation)new FileLocation(file), (ExtensionRegistry)ExplorerExtensionRegistry.getInstance());
                    this.fCache.put(file, icon);
                }
                this.setIcon(icon);
                this.setToolTipText(file.getAbsolutePath());
            } else {
                this.setText(jList.getModel().getSize() > 0 ? this.fNonEmptyNullText : this.fEmptyNullText);
            }
        }
        return component;
    }

    public void flushCache() {
        this.fCache.clear();
    }

    public boolean isWide() {
        return false;
    }
}

