/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.explorer.util.PrefUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.NewOrOpenDialog;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.ProjectClient;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectType;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.widgets.BusyAffordance;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.WorkMonitor;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTClientProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractProjectClient
extends DTClientBase
implements ProjectClient {
    private Component fContentPane;
    private boolean fLoading;
    private JComponent fToolbarComponent;
    private boolean fToolbarNeedsPadding;
    private Project fProject;
    private final String fDefaultTitle;
    private final HyperlinkTextLabel fNoProjectLoadedLink;
    private final WorkMonitor fWorkMonitor;
    private final BusyAffordance fBusyAffordance;

    AbstractProjectClient(String string, String string2) {
        this.fDefaultTitle = string2;
        this.setName(string);
        this.setClientName(string);
        this.setShortTitle(this.fDefaultTitle);
        this.setOnTopWhenUndocked(false);
        this.setLayout(new BorderLayout());
        this.setContentPane((Component)new MJPanel());
        String string3 = BuiltInResources.getString("link.noproject");
        this.fNoProjectLoadedLink = new HyperlinkTextLabel(string3, new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                NewOrOpenDialog.invoke();
            }
        }, false, "link.noproject.innerComponent", string3);
        this.fNoProjectLoadedLink.getComponent().setName("link.noproject");
        this.fWorkMonitor = new WorkMonitor();
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_32x32, BuiltInResources.getString("progress.loading"));
        this.fWorkMonitor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (AbstractProjectClient.this.fWorkMonitor.shouldUseWaitCursor()) {
                    AbstractProjectClient.this.setCursor(Cursor.getPredefinedCursor(3));
                } else {
                    AbstractProjectClient.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        PrefUtils.manageTextColor((Container)((Object)this));
        PrefUtils.manageFonts((Container)((Object)this), null);
        MatlabDesktopServices.getDesktop().addClientListener((Component)((Object)this), (DTClientListener)new DTClientAdapter(){

            public void clientClosing(DTClientEvent dTClientEvent) {
                if (ProjectGUI.getInstance().isCurrentClient(AbstractProjectClient.this)) {
                    ProjectGUI.getInstance().closeCurrentProject();
                }
                AbstractProjectClient.this.fProject = null;
            }
        });
    }

    @Override
    public void projectClosed() {
        this.fProject = null;
    }

    protected void setContentPane(Component component) {
        this.fContentPane = component;
        if (!this.fLoading && this.fProject != null) {
            this.rebuildInProjectMode();
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Project getProject() {
        return this.fProject;
    }

    @Override
    public String getTitle() {
        return (String)this.getClientProperty(DTClientProperty.TITLE);
    }

    protected void switchToNoProjectMode() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractProjectClient.this.updateToolbar();
                AbstractProjectClient.this.disableActionsRequiringOpenProject();
                AbstractProjectClient.this.removeAll();
                AbstractProjectClient.this.setLayout((LayoutManager)new FormLayout("2dlu, 2dlu, fill:d:grow, 2dlu", (AbstractProjectClient.this.fToolbarNeedsPadding ? "2dlu, " : "") + "p, 2dlu, p, 3dlu:grow"));
                CellConstraints cellConstraints = new CellConstraints();
                AbstractProjectClient.this.add(AbstractProjectClient.this.fToolbarComponent, AbstractProjectClient.this.fToolbarNeedsPadding ? cellConstraints.xyw(2, 2, 2) : cellConstraints.xyw(1, 1, 4));
                if (!PluginManager.getTargets().isEmpty()) {
                    AbstractProjectClient.this.add(AbstractProjectClient.this.fNoProjectLoadedLink.getComponent(), cellConstraints.xy(3, AbstractProjectClient.this.fToolbarNeedsPadding ? 4 : 3));
                }
                AbstractProjectClient.this.fBusyAffordance.stop();
                AbstractProjectClient.this.updateTitle();
                AbstractProjectClient.this.revalidate();
                AbstractProjectClient.this.repaint();
            }
        });
    }

    @Override
    public void switchToLoadingMode() {
        this.fLoading = true;
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractProjectClient.this.disableActionsRequiringOpenProject();
                AbstractProjectClient.this.removeAll();
                AbstractProjectClient.this.updateToolbar();
                AbstractProjectClient.this.setLayout((LayoutManager)new FormLayout("2dlu, fill:d:grow, 2dlu", (AbstractProjectClient.this.fToolbarNeedsPadding ? "2dlu, " : "") + "p, 2dlu, fill:d:grow, 4dlu, " + AbstractProjectClient.this.fToolbarComponent.getPreferredSize().getHeight() + "px"));
                CellConstraints cellConstraints = new CellConstraints();
                AbstractProjectClient.this.add(AbstractProjectClient.this.fToolbarComponent, AbstractProjectClient.this.fToolbarNeedsPadding ? cellConstraints.xy(2, 2) : cellConstraints.xyw(1, 1, 3));
                AbstractProjectClient.this.add(AbstractProjectClient.this.fBusyAffordance.getComponent(), cellConstraints.xy(2, AbstractProjectClient.this.fToolbarNeedsPadding ? 4 : 3));
                AbstractProjectClient.this.fBusyAffordance.start();
                AbstractProjectClient.this.revalidate();
                AbstractProjectClient.this.repaint();
            }
        });
    }

    @Override
    public void loadingFinished(final Project project) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractProjectClient.this.fProject = project;
                AbstractProjectClient.this.updateToolbar();
                AbstractProjectClient.this.enableActionsRequiringOpenProject();
                AbstractProjectClient.this.rebuildInProjectMode();
                project.getConfiguration().addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("__project_type")) {
                            AbstractProjectClient.this.projectTypeChanged();
                        } else if (propertyChangeEvent.getPropertyName().equals("@project-window-title")) {
                            AbstractProjectClient.this.updateTitle();
                        }
                    }
                });
                AbstractProjectClient.this.updateTitle();
                AbstractProjectClient.this.fLoading = false;
            }
        });
    }

    protected void projectTypeChanged() {
        this.updateTitle();
    }

    protected abstract void disableActionsRequiringOpenProject();

    protected abstract void enableActionsRequiringOpenProject();

    private void rebuildInProjectMode() {
        this.removeAll();
        this.setLayout((LayoutManager)new FormLayout("2dlu, fill:d:grow, 2dlu", (this.fToolbarNeedsPadding ? "2dlu, " : "") + "p, 2dlu, fill:d:grow"));
        CellConstraints cellConstraints = new CellConstraints();
        this.add(this.fContentPane, cellConstraints.xyw(1, this.fToolbarNeedsPadding ? 4 : 3, 3));
        this.add(this.fToolbarComponent, this.fToolbarNeedsPadding ? cellConstraints.xy(2, 2) : cellConstraints.xyw(1, 1, 3));
        this.fBusyAffordance.stop();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void loadingFailed() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AbstractProjectClient.this.fProject == null) {
                    AbstractProjectClient.this.switchToNoProjectMode();
                } else {
                    AbstractProjectClient.this.rebuildInProjectMode();
                }
                AbstractProjectClient.this.fLoading = false;
            }
        });
    }

    protected abstract void updateToolbar();

    protected void setToolbarComponent(JComponent jComponent, boolean bl) {
        boolean bl2 = this.fToolbarComponent != null && this.getProject() != null;
        this.fToolbarComponent = jComponent;
        this.fToolbarNeedsPadding = bl;
        if (bl2) {
            this.rebuildInProjectMode();
        }
    }

    protected FileSetDefinition getHierarchicalFileSet() {
        if (this.fProject == null) {
            return null;
        }
        for (FileSetDefinition fileSetDefinition : this.fProject.getConfiguration().getTarget().getFileSets()) {
            if (fileSetDefinition.getHierarchyLevels() != 2) continue;
            return fileSetDefinition;
        }
        return null;
    }

    @Override
    public void monitor(Status status) {
        final WorkMonitor.Task task = this.fWorkMonitor.startTask("", true);
        status.addCompletionOrCancellationRunnable(new Runnable(){

            @Override
            public void run() {
                task.finished();
            }
        });
    }

    public void updateTitle() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AbstractProjectClient.this.fProject == null) {
                    AbstractProjectClient.this.setTitle(AbstractProjectClient.this.fDefaultTitle);
                    AbstractProjectClient.this.setShortTitle(AbstractProjectClient.this.fDefaultTitle);
                } else {
                    String string = AbstractProjectClient.this.fProject.getConfiguration().getProjectWindowTitle();
                    if (string != null) {
                        AbstractProjectClient.this.setTitle(string);
                        AbstractProjectClient.this.setShortTitle(string);
                    } else {
                        ProjectType projectType = AbstractProjectClient.this.fProject.getConfiguration().getProjectType();
                        AbstractProjectClient.this.setTitle(projectType.getName());
                        AbstractProjectClient.this.setShortTitle(projectType.getName());
                    }
                }
            }
        });
    }

    public JComponent getToolbarComponent() {
        return this.fToolbarComponent;
    }
}

