/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.DocumentCellRenderer;
import com.mathworks.project.impl.NewOrOpenDialog;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.ProjectClient;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.plaf.LightweightComboBoxUI;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.util.ParameterRunnable;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class HistoryComboBox {
    private final ProjectClient fClient;
    private final JComboBox fHistory;
    private final DocumentCellRenderer fHistoryRenderer;
    private boolean fSuppressHistoryOpen;
    private static final int HISTORY_BOX_LIMIT = 10;

    public HistoryComboBox(ProjectClient projectClient) {
        this.fClient = projectClient;
        this.fHistory = new JComboBox(){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension((int)super.getMaximumSize().getWidth(), (int)this.getPreferredSize().getHeight());
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(0, (int)super.getMinimumSize().getHeight());
            }
        };
        this.fHistoryRenderer = new DocumentCellRenderer(BuiltInResources.getString("history.noselection.empty"), BuiltInResources.getString("history.noselection.nonempty")){

            @Override
            public boolean isWide() {
                return HistoryComboBox.this.fHistory.getWidth() > 400;
            }
        };
        this.fHistory.setName("combobox.history");
        this.fHistory.setUI(new LightweightComboBoxUI());
        this.fHistory.setRenderer(this.fHistoryRenderer);
        this.fHistory.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                HistoryComboBox.this.fHistoryRenderer.flushCache();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.fHistory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!HistoryComboBox.this.fSuppressHistoryOpen && HistoryComboBox.this.fHistory.getSelectedItem() != null) {
                    HistoryComboBox.this.fSuppressHistoryOpen = true;
                    if (HistoryComboBox.this.fHistory.getSelectedItem() instanceof String) {
                        NewOrOpenDialog.browseForProject(HistoryComboBox.this.fClient.getComponent(), new ParameterRunnable<File>(){

                            public void run(File file) {
                                ProjectGUI.getInstance().open(file);
                            }
                        });
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HistoryComboBox.this.reselectCurrentProject();
                                HistoryComboBox.this.fSuppressHistoryOpen = false;
                            }
                        });
                    } else {
                        HistoryComboBox.this.fSuppressHistoryOpen = true;
                        final File file = (File)HistoryComboBox.this.fHistory.getSelectedItem();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProjectGUI.getInstance().open(file);
                            }
                        });
                    }
                }
            }
        });
        ProjectManager.addRecentProjectListListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                HistoryComboBox.this.populateHistoryBox();
                HistoryComboBox.this.reselectCurrentProject();
            }
        });
        this.populateHistoryBox();
        this.fHistory.setEnabled(!PluginManager.getTargets().isEmpty());
    }

    public JComponent getComponent() {
        return this.fHistory;
    }

    public void setSelectedItem(File file) {
        this.fHistory.setSelectedItem(file);
    }

    public void reselectCurrentProject() {
        this.fSuppressHistoryOpen = true;
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Project project = ProjectGUI.getInstance().getCurrentProject();
                if (project == null) {
                    HistoryComboBox.this.fHistory.setSelectedItem(null);
                } else {
                    for (int i = 0; i < HistoryComboBox.this.fHistory.getItemCount(); ++i) {
                        if (!(HistoryComboBox.this.fHistory.getItemAt(i) instanceof File) || !HistoryComboBox.this.fHistory.getItemAt(i).equals(project.getFile())) continue;
                        HistoryComboBox.this.fHistory.setSelectedIndex(i);
                        break;
                    }
                }
                HistoryComboBox.this.fSuppressHistoryOpen = false;
            }
        });
    }

    private void populateHistoryBox() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                HistoryComboBox.this.fSuppressHistoryOpen = true;
                HistoryComboBox.this.fHistory.removeAllItems();
                for (File file : ProjectManager.getRecentProjects(10)) {
                    HistoryComboBox.this.fHistory.addItem(file);
                }
                HistoryComboBox.this.fHistory.addItem(BuiltInResources.getString("button.browse"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HistoryComboBox.this.fSuppressHistoryOpen = false;
                    }
                });
            }
        });
    }

    public void flushRendererCache() {
        this.fHistoryRenderer.flushCache();
        this.fHistory.revalidate();
        this.fHistory.repaint();
    }
}

