/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.mlwidgets.explorer.model.ExplorerExtensionRegistry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.NewOrOpenDialog;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;

public final class OpenDropDownButton {
    private final TSDropDownButton fButton = new TSDropDownButton("Open Project", BuiltInResources.getIcon("toolstrip_open.png"));
    private static final String OPEN_ACTION_PREFIX = "action.open.";

    public OpenDropDownButton() {
        this.fButton.setPopupListener(new PopupListener(){

            public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                ArrayList<ListItem> arrayList = new ArrayList<ListItem>();
                arrayList.add(ListItem.newItem((String)"button.browse", (String)BuiltInResources.getString("button.browse"), (Icon)BuiltInResources.getIcon("toolstrip_open.png")));
                for (File file : ProjectManager.getRecentProjects(10)) {
                    arrayList.add(ListItem.newItem((String)(OpenDropDownButton.OPEN_ACTION_PREFIX + file.getAbsolutePath()), (String)file.getAbsolutePath(), (String)file.getAbsolutePath(), (Icon)UiFileSystemUtils.getIconEvenIfNonExistent((FileSystem)RealFileSystem.getInstance(), (FileLocation)new FileLocation(file), (ExtensionRegistry)ExplorerExtensionRegistry.getInstance())));
                }
                PopupList popupList = new PopupList(arrayList.toArray(new ListItem[arrayList.size()]));
                popupList.addListActionListener(new ListActionListener(){

                    public void listItemSelected(ListActionEvent listActionEvent) {
                        if (listActionEvent.getListItem().getName().equals("button.browse")) {
                            NewOrOpenDialog.invoke(true);
                        } else {
                            ProjectGUI.getInstance().open(listActionEvent.getListItem().getName().substring(OpenDropDownButton.OPEN_ACTION_PREFIX.length()));
                        }
                    }
                });
                popupList.setListStyle(ListStyle.ICON_TEXT);
                popupCallback.show((JComponent)popupList);
            }
        });
    }

    public JComponent getComponent() {
        return this.fButton;
    }
}

