/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.engine;

import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.impl.engine.DeploymentProcessImpl;
import java.util.concurrent.CountDownLatch;

final class CommandStatusImpl
implements CommandStatus {
    private final DeploymentProcessImpl fProcess;
    private final CountDownLatch fCompletion;
    private final Command fCommand;
    private CommandExecutionException fException;
    private boolean fCanceled;

    CommandStatusImpl(Command command, DeploymentProcessImpl deploymentProcessImpl) {
        this.fCommand = command;
        this.fProcess = deploymentProcessImpl;
        this.fCompletion = new CountDownLatch(1);
    }

    void waitForCompletion() throws InterruptedException {
        this.fCompletion.await();
    }

    public void canceled() {
        this.fCanceled = true;
        this.fCompletion.countDown();
    }

    public void finished() {
        this.fCompletion.countDown();
    }

    public void failed(CommandExecutionException commandExecutionException) {
        this.fException = commandExecutionException;
        this.fCompletion.countDown();
    }

    public void printErrorLine(String string) {
        this.fProcess.fireErrorLine(this.fCommand, string);
    }

    public void printOutputLine(String string) {
        this.fProcess.fireOutputLine(this.fCommand, string);
    }

    public boolean isCanceled() {
        return this.fCanceled;
    }

    public CommandExecutionException getError() {
        return this.fException;
    }
}

