/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.logui;

import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.api.SubProcessType;
import com.mathworks.project.impl.logui.LogDisplay;
import com.mathworks.project.impl.logui.LogMessage;
import com.mathworks.project.impl.logui.LogMessageType;
import com.mathworks.project.impl.logui.LogSource;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;

public final class BufferedLogSource
implements LogSource {
    private final List<LogMessage> fBuffer = new LinkedList<LogMessage>();
    private final Object fWriteLock = new Object();
    private LogDisplay fBoundDisplay;
    private boolean fProcessSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcess(DeploymentProcess deploymentProcess) {
        Object object = this.fWriteLock;
        synchronized (object) {
            this.fProcessSet = true;
            this.fBuffer.clear();
            if (this.fBoundDisplay != null) {
                this.fBoundDisplay.clear();
            }
        }
        deploymentProcess.addMonitor(new DeploymentProcessMonitor(){

            public void subProcessStarted(SubProcessType subProcessType) {
            }

            public void commandStarted(String string) {
                if (BufferedLogSource.this.fBoundDisplay != null) {
                    BufferedLogSource.this.fBoundDisplay.setLive(true);
                }
                if (!string.isEmpty()) {
                    BufferedLogSource.this.write(new LogMessage(string, LogMessageType.COMMAND));
                }
            }

            public void commandOutput(String string) {
                BufferedLogSource.this.write(new LogMessage(string, LogMessageType.OUTPUT));
            }

            public void commandError(String string) {
                BufferedLogSource.this.write(new LogMessage(string, LogMessageType.ERROR));
            }

            public void finished() {
            }

            public void failed() {
            }

            public void canceled() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlainText() {
        Object object = this.fWriteLock;
        synchronized (object) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            for (LogMessage logMessage : this.fBuffer) {
                printWriter.println(logMessage.getLine());
            }
            printWriter.close();
            return stringWriter.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.fWriteLock;
        synchronized (object) {
            this.fBuffer.clear();
            this.fProcessSet = false;
            if (this.fBoundDisplay != null) {
                this.fBoundDisplay.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LogMessage logMessage) {
        Object object = this.fWriteLock;
        synchronized (object) {
            this.fBuffer.add(logMessage);
            if (this.fBoundDisplay != null) {
                this.fBoundDisplay.write(logMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(LogDisplay logDisplay) {
        logDisplay.clear();
        Object object = this.fWriteLock;
        synchronized (object) {
            logDisplay.setLive(this.fProcessSet || !this.fBuffer.isEmpty());
            for (LogMessage logMessage : this.fBuffer) {
                logDisplay.write(logMessage);
            }
            logDisplay.flush();
            this.fBoundDisplay = logDisplay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind() {
        Object object = this.fWriteLock;
        synchronized (object) {
            this.fBoundDisplay = null;
        }
    }
}

