/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.api.ReadableEntityInstance;
import com.mathworks.project.api.WritableEntityInstance;
import com.mathworks.project.api.WritableFileSet;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.DynamicFileReference;
import com.mathworks.project.impl.model.DynamicFileSubset;
import com.mathworks.project.impl.model.EntityDefinition;
import com.mathworks.project.impl.model.EntityInstance;
import com.mathworks.project.impl.model.FileReferenceMode;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.SpecialFile;
import com.mathworks.util.CollectionMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class FileSetInstance
implements WritableFileSet {
    private final boolean fMutable;
    private final Project fProject;
    private final FileSetInstance fOriginal;
    private final Object fChangeLock;
    private final FileSetDefinition fDefinition;
    private final Set<File> fFiles;
    private final Set<File> fSnapshotDynamicFiles;
    private final List<EntityInstance> fRootEntities;
    private final List<DynamicFileSubset> fDynamicSubsets;
    private final Map<File, FileReferenceMode> fReferenceModes;
    private final Map<File, String> fCustomData;
    private final Set<File> fCustomDataExpanded;
    private final CollectionMap<EntityInstance, EntityInstance> fChildEntitiesByParent;
    private final CollectionMap<File, EntityInstance> fEntitiesByFile;
    private final CollectionMap<PropertyChangeListener, EntityInstance> fListenedEntities;
    private final PropertyChangeSupport fPropertySupport;
    public static final String FILES_PROPERTY = "files";
    public static final String ENTITIES_PROPERTY = "entities";
    public static final String ENTITIES_BY_FILE_PROPERTY = "entities-by-file";
    public static final String CUSTOM_DATA_PROPERTY = "custom-data";
    public static final String CUSTOM_DATA_EXPANDED_PROPERTY = "custom-data-expanded";

    public FileSetInstance(FileSetDefinition fileSetDefinition, Project project) {
        assert (fileSetDefinition != null);
        assert (project != null);
        this.fProject = project;
        this.fMutable = true;
        this.fChangeLock = new Object();
        this.fSnapshotDynamicFiles = null;
        this.fListenedEntities = new CollectionMap();
        this.fOriginal = this;
        this.fCustomDataExpanded = new HashSet<File>();
        this.fFiles = new TreeSet<File>();
        this.fReferenceModes = new TreeMap<File, FileReferenceMode>();
        this.fCustomData = new TreeMap<File, String>();
        this.fRootEntities = new ArrayList<EntityInstance>();
        this.fChildEntitiesByParent = new CollectionMap();
        this.fEntitiesByFile = new CollectionMap(HashMap.class, HashSet.class);
        this.fDynamicSubsets = new ArrayList<DynamicFileSubset>();
        this.fPropertySupport = new PropertyChangeSupport(this);
        this.fDefinition = fileSetDefinition;
        this.addEntityWatcher();
    }

    private FileSetInstance(FileSetInstance fileSetInstance) {
        assert (fileSetInstance != null);
        this.fMutable = false;
        this.fProject = fileSetInstance.fProject;
        this.fOriginal = fileSetInstance;
        this.fListenedEntities = new CollectionMap();
        this.fChangeLock = new Object();
        this.fDefinition = fileSetInstance.getDefinition();
        this.fFiles = new TreeSet<File>(fileSetInstance.getFiles());
        this.fReferenceModes = new TreeMap<File, FileReferenceMode>(fileSetInstance.getReferenceModes());
        this.fDynamicSubsets = new ArrayList<DynamicFileSubset>(fileSetInstance.getDynamicSubsets());
        this.fRootEntities = new ArrayList<EntityInstance>();
        this.fCustomData = new TreeMap<File, String>(fileSetInstance.fCustomData);
        this.fCustomDataExpanded = new HashSet<File>(fileSetInstance.fCustomDataExpanded);
        for (EntityInstance object : fileSetInstance.getRootEntities()) {
            this.fRootEntities.add(new EntityInstance(object));
        }
        this.fEntitiesByFile = new CollectionMap(HashMap.class, HashSet.class);
        for (Map.Entry entry : fileSetInstance.getEntitiesByFile().entrySet()) {
            for (EntityInstance entityInstance : (Collection)entry.getValue()) {
                this.fEntitiesByFile.add(entry.getKey(), (Object)new EntityInstance(entityInstance));
            }
        }
        this.fChildEntitiesByParent = new CollectionMap();
        for (Map.Entry entry : fileSetInstance.getChildEntitiesByParent().entrySet()) {
            for (EntityInstance entityInstance : (List)entry.getValue()) {
                this.fChildEntitiesByParent.add((Object)new EntityInstance((EntityInstance)entry.getKey()), (Object)new EntityInstance(entityInstance));
            }
        }
        this.fSnapshotDynamicFiles = this.getDynamicFiles();
        this.fPropertySupport = new PropertyChangeSupport(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomDataExpanded(File file, boolean bl) {
        Object object = this.fChangeLock;
        synchronized (object) {
            boolean bl2 = this.isCustomDataExpanded(file);
            if (bl) {
                this.fCustomDataExpanded.add(file);
            } else {
                this.fCustomDataExpanded.remove(file);
            }
            this.fPropertySupport.firePropertyChange("custom-data-expanded-" + file, bl2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCustomDataExpanded(File file) {
        Object object = this.fChangeLock;
        synchronized (object) {
            return this.fCustomDataExpanded.contains(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyCustomData() {
        Object object = this.fChangeLock;
        synchronized (object) {
            return !this.fCustomData.isEmpty();
        }
    }

    private void addEntityWatcher() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PropertyChangeSupport propertyChangeSupport = FileSetInstance.this.fPropertySupport;
                synchronized (propertyChangeSupport) {
                    for (PropertyChangeListener propertyChangeListener : FileSetInstance.this.fPropertySupport.getPropertyChangeListeners()) {
                        FileSetInstance.this.removeFromAllEntities(propertyChangeListener);
                        FileSetInstance.this.listenToEntities(FileSetInstance.this.getRootEntities(), propertyChangeListener);
                    }
                }
            }
        });
    }

    public void addSpecialFileWatcher() {
        this.fProject.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                for (SpecialFile specialFile : FileSetInstance.this.fDefinition.getSpecialFiles()) {
                    if (!specialFile.getKey().equals(propertyChangeEvent.getPropertyName())) continue;
                    FileSetInstance.this.changeSpecialFileLocation((File)propertyChangeEvent.getOldValue(), (File)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeSpecialFileLocation(File file, File file2) {
        Object object = this.fChangeLock;
        synchronized (object) {
            if (this.fFiles.contains(file)) {
                Set<File> set = this.getFiles();
                this.fFiles.remove(file);
                if (this.fCustomData.get(file) != null) {
                    this.fCustomData.put(file2, this.fCustomData.remove(file));
                }
                if (this.fCustomDataExpanded.remove(file)) {
                    this.fCustomDataExpanded.add(file2);
                }
                this.fFiles.add(file2);
                this.fPropertySupport.firePropertyChange(FILES_PROPERTY, set, this.getFiles());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EntityInstance entityInstance) {
        ArrayList<EntityInstance> arrayList;
        ArrayList<EntityInstance> arrayList2;
        assert (this.fDefinition.getHierarchyLevels() > 1);
        assert (this.fDefinition.getRootLevelEntities().contains(entityInstance.getDefinition()));
        Object object = this.fChangeLock;
        synchronized (object) {
            arrayList2 = new ArrayList<EntityInstance>(this.fRootEntities);
            this.fRootEntities.add(entityInstance);
            arrayList = new ArrayList<EntityInstance>(this.fRootEntities);
        }
        this.fPropertySupport.firePropertyChange(ENTITIES_PROPERTY, arrayList2, arrayList);
    }

    public WritableEntityInstance addEntity(String string, ReadableEntityInstance readableEntityInstance, String string2) {
        EntityDefinition entityDefinition = this.findChildEntity(readableEntityInstance, string);
        if (entityDefinition == null) {
            throw new IllegalArgumentException("The entity type key '" + string + "' is invalid under parent " + readableEntityInstance);
        }
        EntityInstance entityInstance = new EntityInstance(entityDefinition);
        this.assignDefaultName((EntityInstance)readableEntityInstance, entityInstance);
        this.add(entityInstance);
        return entityInstance;
    }

    private EntityDefinition findChildEntity(ReadableEntityInstance readableEntityInstance, String string) {
        List<EntityDefinition> list = readableEntityInstance == null ? this.fDefinition.getRootLevelEntities() : ((EntityInstance)readableEntityInstance).getDefinition().getChildren();
        for (EntityDefinition entityDefinition : list) {
            if (!entityDefinition.getKey().equals(string)) continue;
            return entityDefinition;
        }
        return null;
    }

    public void add(Set<File> set) {
        this.add(null, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(DynamicFileSubset dynamicFileSubset) {
        Set<File> set;
        Set<File> set2;
        assert (this.fMutable);
        assert (dynamicFileSubset != null);
        Object object = this.fChangeLock;
        synchronized (object) {
            set2 = this.getFiles();
            this.fDynamicSubsets.add(dynamicFileSubset);
            set = this.getFiles();
        }
        this.fPropertySupport.firePropertyChange(FILES_PROPERTY, set2, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ReadableEntityInstance readableEntityInstance, Set<File> set) {
        Set<File> set2;
        Set<File> set3;
        assert (set != null);
        assert (this.fMutable);
        Object object = this.fChangeLock;
        synchronized (object) {
            set3 = this.getFiles();
            String string = this.validateAdd(null, set, false);
            if (string != null) {
                throw new IllegalArgumentException("Adding " + Arrays.toString(set.toArray()) + " failed validation: " + string);
            }
            for (File file : set) {
                if (set3.contains(file)) continue;
                this.fFiles.add(file);
            }
            set2 = this.getFiles();
            if (readableEntityInstance != null) {
                for (File file : set) {
                    Collection collection = this.fEntitiesByFile.get((Object)file);
                    this.fEntitiesByFile.add((Object)file, (Object)((EntityInstance)readableEntityInstance));
                    Collection collection2 = this.fEntitiesByFile.get((Object)file);
                    this.fPropertySupport.firePropertyChange("entities-by-file - " + file.getAbsolutePath(), collection, collection2);
                }
            }
        }
        this.fPropertySupport.firePropertyChange(FILES_PROPERTY, set3, set2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(List<File> list) {
        Set<File> set;
        Set<File> set2;
        assert (list != null);
        assert (this.fMutable);
        Object object = this.fChangeLock;
        synchronized (object) {
            set2 = this.getFiles();
            this.fFiles.removeAll(list);
            this.fCustomDataExpanded.removeAll(list);
            for (File file : list) {
                this.fEntitiesByFile.remove((Object)file);
                this.fCustomData.remove(file);
            }
            set = this.getFiles();
        }
        this.fPropertySupport.firePropertyChange(FILES_PROPERTY, set2, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ReadableEntityInstance readableEntityInstance, List<File> list) {
        Set<File> set;
        Set<File> set2;
        assert (list != null);
        assert (readableEntityInstance != null);
        assert (this.fMutable);
        Object object = this.fChangeLock;
        synchronized (object) {
            set2 = this.getFiles();
            for (File file : list) {
                Collection collection = this.fEntitiesByFile.get((Object)file);
                this.fEntitiesByFile.remove((Object)file, (Object)((EntityInstance)readableEntityInstance));
                this.fCustomData.remove(file);
                this.fCustomDataExpanded.remove(file);
                Collection collection2 = this.fEntitiesByFile.get((Object)file);
                this.fPropertySupport.firePropertyChange("entities-by-file - " + file.getAbsolutePath(), collection, collection2);
                if (!this.fEntitiesByFile.get((Object)file).isEmpty()) continue;
                this.fFiles.remove(file);
            }
            set = this.getFiles();
        }
        this.fPropertySupport.firePropertyChange(FILES_PROPERTY, set2, set);
    }

    public FileSetDefinition getDefinition() {
        return this.fDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentCount() {
        Object object = this.fChangeLock;
        synchronized (object) {
            return this.getFiles().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> getNonSubsetFiles() {
        Object object = this.fChangeLock;
        synchronized (object) {
            return new TreeSet<File>(this.fFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> getFiles() {
        Object object = this.fChangeLock;
        synchronized (object) {
            TreeSet<File> treeSet = new TreeSet<File>(this.fFiles);
            Set<File> set = this.getDynamicFiles();
            treeSet.addAll(set);
            return FileSetInstance.sortFiles(treeSet, set);
        }
    }

    public Set<File> getDynamicFiles() {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        if (this.fSnapshotDynamicFiles != null) {
            linkedHashSet.addAll(this.fSnapshotDynamicFiles);
        } else if (!this.fDynamicSubsets.isEmpty()) {
            for (DynamicFileSubset dynamicFileSubset : this.fDynamicSubsets) {
                for (DynamicFileReference dynamicFileReference : this.fProject.getConfiguration().evaluateDynamicFileSubset(dynamicFileSubset)) {
                    File file = dynamicFileReference.getFile();
                    if (file == null) {
                        throw new IllegalStateException("Invalid build deliverable with location: " + file + ". If a deliverable is not always " + "applicable, make sure the file itself is conditional and not its location.");
                    }
                    linkedHashSet.add(file);
                }
            }
        }
        return linkedHashSet;
    }

    private static Set<File> sortFiles(Set<File> set, final Set<File> set2) {
        TreeSet<File> treeSet = new TreeSet<File>(new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                boolean bl;
                boolean bl2 = set2.contains(file);
                if (bl2 ^ (bl = set2.contains(file2))) {
                    return bl2 ? -1 : 1;
                }
                String string = file.getName() == null ? "" : file.getName();
                String string2 = file2.getName() == null ? "" : file2.getName();
                int n = string.compareToIgnoreCase(string2);
                return n == 0 ? file.compareTo(file2) : n;
            }
        });
        treeSet.addAll(set);
        return treeSet;
    }

    public String validateAdd(Set<File> set) {
        return this.validateAdd(null, set);
    }

    public String validateAdd(ReadableEntityInstance readableEntityInstance, Set<File> set) {
        return this.validateAdd(readableEntityInstance, set, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String validateAdd(ReadableEntityInstance readableEntityInstance, Set<File> set, boolean bl) {
        Object object = this.fChangeLock;
        synchronized (object) {
            HashSet<File> hashSet = new HashSet<File>(set);
            hashSet.removeAll(this.getFiles());
            if (this.getFiles().size() + hashSet.size() > this.fDefinition.getMaxCount()) {
                return this.fDefinition.getSizeError();
            }
            for (File file : hashSet) {
                if (!this.fDefinition.allow(file)) {
                    return this.fDefinition.getPatternError();
                }
                if (!bl || file.exists()) continue;
                return MessageFormat.format(BuiltInResources.getString("error.fileset.nonexistent.file"), file.getName());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<EntityInstance> getEntityInstances(File file) {
        Object object = this.fChangeLock;
        synchronized (object) {
            HashSet<EntityInstance> hashSet = new HashSet<EntityInstance>();
            if (this.fEntitiesByFile.get((Object)file) != null) {
                hashSet.addAll(this.fEntitiesByFile.get((Object)file));
            }
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EntityInstance> getRootEntities() {
        Object object = this.fChangeLock;
        synchronized (object) {
            return new ArrayList<EntityInstance>(this.fRootEntities);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EntityInstance> getChildren(ReadableEntityInstance readableEntityInstance) {
        Object object = this.fChangeLock;
        synchronized (object) {
            return new ArrayList<EntityInstance>(this.fChildEntitiesByParent.get((Object)((EntityInstance)readableEntityInstance)));
        }
    }

    public void normalize() {
        if (this.fDefinition.getHierarchyLevels() > 1) {
            EntityInstance entityInstance;
            if (!this.getRootEntities().isEmpty()) {
                entityInstance = this.getRootEntities().get(0);
            } else {
                entityInstance = new EntityInstance(this.getDefinition().getRootLevelEntities().get(0));
                this.add(entityInstance);
            }
            EntityDefinition entityDefinition = entityInstance.getDefinition().getChildren().get(0);
            if (entityDefinition.getMaxCount() == 1 && entityDefinition.getMinCount() == 1) {
                if (this.getChildren((ReadableEntityInstance)entityInstance).isEmpty()) {
                    EntityInstance entityInstance2 = new EntityInstance(entityDefinition);
                    this.assignDefaultName(entityInstance, entityInstance2);
                    this.addChild(entityInstance, entityInstance2);
                } else {
                    List<EntityInstance> list = this.getChildren((ReadableEntityInstance)entityInstance);
                    for (int i = 1; i < list.size(); ++i) {
                        this.removeEntity((ReadableEntityInstance)entityInstance, (ReadableEntityInstance)list.get(i));
                    }
                }
            }
        }
    }

    public void assignDefaultName(EntityInstance entityInstance, EntityInstance entityInstance2) {
        int n;
        block0: for (n = 1; n < 10000; ++n) {
            for (EntityInstance entityInstance3 : this.getChildren((ReadableEntityInstance)entityInstance)) {
                if (!entityInstance3.getName().equals(entityInstance2.getDefinition().getNonLocalizedName() + n)) continue;
                continue block0;
            }
        }
        entityInstance2.setName(entityInstance2.getDefinition().getNonLocalizedName() + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(EntityInstance entityInstance, EntityInstance entityInstance2) {
        Object object = this.fChangeLock;
        synchronized (object) {
            this.fChildEntitiesByParent.add((Object)entityInstance, (Object)entityInstance2);
        }
        this.fPropertySupport.firePropertyChange(ENTITIES_PROPERTY, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntity(ReadableEntityInstance readableEntityInstance, ReadableEntityInstance readableEntityInstance2) {
        this.remove(readableEntityInstance2, new ArrayList<File>(this.getFilesForEntity(readableEntityInstance2)));
        Object object = this.fChangeLock;
        synchronized (object) {
            this.fChildEntitiesByParent.remove((Object)((EntityInstance)readableEntityInstance), (Object)((EntityInstance)readableEntityInstance2));
        }
        this.fPropertySupport.firePropertyChange(ENTITIES_PROPERTY, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> getFilesForEntity(ReadableEntityInstance readableEntityInstance) {
        Object object = this.fChangeLock;
        synchronized (object) {
            TreeSet<File> treeSet = new TreeSet<File>();
            for (File file : this.fFiles) {
                if (!this.fEntitiesByFile.get((Object)file).contains((EntityInstance)readableEntityInstance)) continue;
                treeSet.add(file);
            }
            return FileSetInstance.sortFiles(treeSet, new TreeSet<File>());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        assert (this.fMutable);
        PropertyChangeSupport propertyChangeSupport = this.fPropertySupport;
        synchronized (propertyChangeSupport) {
            this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
            this.listenToEntities(this.getRootEntities(), propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenToEntities(List<EntityInstance> list, PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.fPropertySupport;
        synchronized (propertyChangeSupport) {
            for (EntityInstance entityInstance : list) {
                entityInstance.addPropertyChangeListener(propertyChangeListener);
                this.fListenedEntities.add((Object)propertyChangeListener, (Object)entityInstance);
                this.listenToEntities(this.getChildren((ReadableEntityInstance)entityInstance), propertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromAllEntities(PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.fPropertySupport;
        synchronized (propertyChangeSupport) {
            for (EntityInstance entityInstance : this.fListenedEntities.remove((Object)propertyChangeListener)) {
                entityInstance.removePropertyChangeListener(propertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.fPropertySupport;
        synchronized (propertyChangeSupport) {
            this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
            this.removeFromAllEntities(propertyChangeListener);
        }
    }

    public FileSetInstance getSnapshot() {
        return new FileSetInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectionMap<File, EntityInstance> getEntitiesByFile() {
        Object object = this.fChangeLock;
        synchronized (object) {
            return new CollectionMap(this.fEntitiesByFile);
        }
    }

    private Map<EntityInstance, List<EntityInstance>> getChildEntitiesByParent() {
        HashMap<EntityInstance, List<EntityInstance>> hashMap = new HashMap<EntityInstance, List<EntityInstance>>();
        for (Map.Entry entry : this.fChildEntitiesByParent.entrySet()) {
            hashMap.put((EntityInstance)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        return hashMap;
    }

    public long getSizeEstimate() {
        long l = 0L;
        for (File file : this.getFiles()) {
            FileReferenceMode fileReferenceMode = this.getReferenceMode(file);
            if (fileReferenceMode != FileReferenceMode.DIRECT) continue;
            l += file.length();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomData(File file, String string) {
        String string2;
        Object object = this.fChangeLock;
        synchronized (object) {
            string2 = this.fCustomData.get(file);
            this.fCustomData.put(file, string);
        }
        this.fPropertySupport.firePropertyChange("custom-data-" + file.getAbsolutePath(), string2, string);
    }

    public XmlReader getCustomData(File file) {
        Object object = this.fChangeLock;
        synchronized (object) {
            try {
                String string = this.fCustomData.get(file);
                if (string == null) {
                    return null;
                }
                return XmlApi.getInstance().read(string);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReferenceMode(File file, FileReferenceMode fileReferenceMode) {
        Object object = this.fChangeLock;
        synchronized (object) {
            this.fReferenceModes.put(file, fileReferenceMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileReferenceMode getReferenceMode(File file) {
        Object object = this.fChangeLock;
        synchronized (object) {
            FileReferenceMode fileReferenceMode = this.fReferenceModes.get(file);
            return fileReferenceMode == null ? FileReferenceMode.DIRECT : fileReferenceMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<File, FileReferenceMode> getReferenceModes() {
        Object object = this.fChangeLock;
        synchronized (object) {
            return new TreeMap<File, FileReferenceMode>(this.fReferenceModes);
        }
    }

    public List<DynamicFileSubset> getDynamicSubsets() {
        return new ArrayList<DynamicFileSubset>(this.fDynamicSubsets);
    }

    public int hashCode() {
        return this.fOriginal == this ? super.hashCode() : this.fOriginal.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileSetInstance)) {
            return false;
        }
        FileSetInstance fileSetInstance = (FileSetInstance)object;
        if (this == this.fOriginal && fileSetInstance.fOriginal == fileSetInstance) {
            return this == fileSetInstance;
        }
        return this.fOriginal.equals(fileSetInstance.fOriginal);
    }

    public String toString() {
        return this.fDefinition.toString();
    }
}

