/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.impl.util.StringUtils;
import java.io.File;

public final class FileSetRule {
    private final String fExpression;
    private boolean fIsDenyRule;

    public FileSetRule(String string, boolean bl) {
        assert (string != null);
        this.fExpression = string;
        this.fIsDenyRule = bl;
    }

    public boolean appliesTo(File file) {
        return StringUtils.matchesWildcardPattern(file.getName(), this.fExpression);
    }

    public boolean appliesToAllFiles() {
        return this.fExpression.equals("*.*") || this.fExpression.equals("*");
    }

    public String getExpression() {
        return this.fExpression;
    }

    public boolean isDenyRule() {
        return this.fIsDenyRule;
    }

    public boolean isAllowRule() {
        return !this.fIsDenyRule;
    }
}

