/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.FileReferenceMode;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.FileSetInstance;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public final class GeneratedReferenceSet {
    private final File fFolder;
    private final Map<String, Map<File, File>> fReferenceFiles = new HashMap<String, Map<File, File>>();

    public GeneratedReferenceSet(Configuration configuration) throws IOException {
        this.fFolder = File.createTempFile("deploytool_generated_references", "");
        this.fFolder.delete();
        this.fFolder.mkdirs();
        for (FileSetDefinition fileSetDefinition : configuration.getTarget().getFileSets()) {
            HashMap<File, File> hashMap = new HashMap<File, File>();
            this.fReferenceFiles.put(fileSetDefinition.getKey(), hashMap);
            FileSetInstance fileSetInstance = configuration.getFileSet(fileSetDefinition.getKey());
            for (File file : fileSetInstance.getFiles()) {
                FileReferenceMode fileReferenceMode;
                if (hashMap.containsKey(file) || (fileReferenceMode = fileSetInstance.getReferenceMode(file)) == FileReferenceMode.DIRECT) continue;
                File file2 = fileReferenceMode.generateReference(file, this.fFolder);
                hashMap.put(file, file2);
            }
        }
    }

    public File getReferenceFile(FileSetInstance fileSetInstance, File file) {
        return this.getReferenceFile(fileSetInstance.getDefinition(), file);
    }

    public File getReferenceFile(FileSetDefinition fileSetDefinition, File file) {
        Map<File, File> map = this.fReferenceFiles.get(fileSetDefinition.getKey());
        if (map == null) {
            return file;
        }
        File file2 = map.get(file);
        return file2 == null ? file : file2;
    }

    public void dispose() throws IOException {
        FileUtils.forceDelete((File)this.fFolder);
    }
}

