/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.project.impl.model.OptionListWithDefault;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.ReferenceSource;
import com.mathworks.project.impl.plugin.DefaultXpathEvaluator;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.plugin.XpathEvaluator;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.util.ParameterRunnable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public final class MatlabExpression
implements ReferenceSource {
    private final String fText;
    private final Map<Integer, String> fParameters;
    private static final Matlab MATLAB = new Matlab();

    public MatlabExpression(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.fParameters = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '$' && i < string.length() - 1 && string.charAt(i + 1) == '{') {
                int n = string.indexOf(125, i += 2);
                String string2 = string.substring(i, n);
                this.fParameters.put(stringBuilder.length(), string2);
                stringBuilder.append('*');
                i = n;
                continue;
            }
            stringBuilder.append(c);
        }
        this.fText = stringBuilder.toString();
    }

    @Override
    public boolean hasReference(String string) {
        for (String string2 : this.fParameters.values()) {
            if (!string2.contains(string)) continue;
            return true;
        }
        return false;
    }

    public void evaluate(Project project, boolean bl, final String[] stringArray) {
        DefaultXpathEvaluator defaultXpathEvaluator = new DefaultXpathEvaluator("configuration");
        final String string = this.getCode(defaultXpathEvaluator.compileInput(ProjectManager.configurationToXslInput(project).getXML()), defaultXpathEvaluator);
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        MatlabWorker<String> matlabWorker = new MatlabWorker<String>(){

            public String runOnMatlabThread() throws Exception {
                String string3 = "";
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        string3 = string3 + stringArray[i];
                        if (i >= stringArray.length - 1) continue;
                        string3 = string3 + ", ";
                    }
                }
                String string2 = stringArray == null ? string : string + "(" + string3 + ")";
                Object[] objectArray = new Object[]{string2};
                1.feval((String)"eval", (Object[])objectArray, (int)0);
                return "";
            }

            public void runOnAWTEventDispatchThread(String string2) {
                countDownLatch.countDown();
            }
        };
        matlabWorker.start();
        if (bl) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException(interruptedException);
            }
        }
    }

    public void evaluate(Project project, boolean bl) {
        this.evaluate(project, bl, null);
    }

    public <CompiledInputType, CompiledXPathType> void evaluate(CompiledInputType CompiledInputType, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, final ParameterRunnable<OptionListWithDefault> parameterRunnable) {
        final String string = this.getCode(CompiledInputType, xpathEvaluator);
        MATLAB.fevalConsoleOutput("eval", new Object[]{string}, 2, new CompletionObserver(){

            public void completed(int n, Object object) {
                LinkedHashMap<String, String> linkedHashMap;
                String string3;
                if (Matlab.getExecutionStatus((int)n) == 0) {
                    Object[] objectArray = (Object[])object;
                    String[] stringArray = (String[])objectArray[0];
                    string3 = (String)objectArray[1];
                    linkedHashMap = new LinkedHashMap<String, String>();
                    for (String string2 : stringArray) {
                        linkedHashMap.put(string2, string2);
                    }
                    if (!linkedHashMap.containsKey(string3)) {
                        throw new IllegalStateException("MATLAB code '" + string + "' returned default option '" + string3 + "' not in the list of options: " + linkedHashMap.values());
                    }
                } else {
                    throw new IllegalStateException("Unable to execute MATLAB code: '" + string + "'");
                }
                parameterRunnable.run((Object)new OptionListWithDefault(linkedHashMap, string3));
            }
        });
    }

    public <CompiledInputType, CompiledXPathType> void evaluateAsString(CompiledInputType CompiledInputType, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, final ParameterRunnable<String> parameterRunnable) {
        this.evaluateAsObject(CompiledInputType, xpathEvaluator, new ParameterRunnable<Object>(){

            public void run(Object object) {
                parameterRunnable.run((Object)object.toString());
            }
        });
    }

    public <CompiledInputType, CompiledXPathType> void evaluateAsObject(CompiledInputType CompiledInputType, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator, final ParameterRunnable<Object> parameterRunnable) {
        final String string = this.getCode(CompiledInputType, xpathEvaluator);
        CompletionObserver completionObserver = new CompletionObserver(){

            public void completed(int n, Object object) {
                if (Matlab.getExecutionStatus((int)n) != 0) {
                    throw new IllegalStateException("Unable to execute MATLAB code: '" + string + "'");
                }
                parameterRunnable.run(object);
            }
        };
        if (PluginManager.isMatlabThreadUseAllowed() && Matlab.isMatlabAvailable() && NativeMatlab.nativeIsMatlabThread()) {
            try {
                Object object = Matlab.mtFevalConsoleOutput((String)"eval", (Object[])new Object[]{string}, (int)1);
                parameterRunnable.run(object);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unable to execute MATLAB code: '" + string + "'", exception);
            }
        } else {
            MATLAB.fevalConsoleOutput("eval", new Object[]{string}, 1, completionObserver);
        }
    }

    <CompiledInputType, CompiledXPathType> String getCode(CompiledInputType CompiledInputType, XpathEvaluator<CompiledInputType, CompiledXPathType> xpathEvaluator) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : this.fParameters.values()) {
            CompiledXPathType CompiledXPathType = xpathEvaluator.compileXPath(string);
            hashMap.put(string, xpathEvaluator.evaluate(CompiledInputType, CompiledXPathType));
        }
        StringBuilder stringBuilder = new StringBuilder(this.fText);
        int n = 0;
        for (Map.Entry entry : this.fParameters.entrySet()) {
            String string = (String)entry.getValue();
            int n2 = (Integer)entry.getKey() + n;
            String string2 = (String)hashMap.get(string);
            stringBuilder.replace(n2, n2 + 1, string2);
            n += string2.length() - 1;
        }
        return StringUtils.normalizeSpace(stringBuilder.toString());
    }
}

