/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.InvalidFormatException;
import com.mathworks.project.api.InvalidProjectException;
import com.mathworks.project.api.ProjectApi;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.UnavailableTargetException;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.impl.engine.DeploymentEngine;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.PackageType;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.util.Predicate;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;

final class ProjectApiImpl
extends ProjectApi {
    ProjectApiImpl() {
    }

    public boolean isNonStandardProjectFormat(File file) throws IOException, InvalidFormatException, UnavailableTargetException {
        return ProjectManager.isNonStandardProjectFormat(file);
    }

    public WritableConfiguration openProject(File file) throws IOException, InvalidFormatException, UnavailableTargetException {
        PluginManager.allowMatlabThreadUse();
        Project project = ProjectManager.load(file, true, true);
        return project.getConfiguration();
    }

    public void saveProject(ReadableConfiguration readableConfiguration, File file) throws IOException {
        ProjectManager.save(ProjectApiImpl.assembleProject(readableConfiguration, file));
    }

    public List<ValidationMessage> validate(ReadableConfiguration readableConfiguration, File file, boolean bl) {
        return ProjectManager.validate(ProjectApiImpl.assembleProject(readableConfiguration, file), bl);
    }

    public DeploymentProcess createBuildProcess(ReadableConfiguration readableConfiguration, File file) throws InvalidProjectException {
        return DeploymentEngine.createBuildProcess(ProjectApiImpl.assembleProject(readableConfiguration, file));
    }

    public DeploymentProcess createPackageProcess(ReadableConfiguration readableConfiguration, File file, String string, File file2, final Callable<Boolean> callable) throws InvalidProjectException {
        Project project = ProjectApiImpl.assembleProject(readableConfiguration, file);
        PackageType packageType = project.getConfiguration().getTarget().getPackageTypeByKey(project, string);
        if (packageType == null) {
            throw new IllegalArgumentException("Unrecognized package type key: '" + string + "'");
        }
        return DeploymentEngine.createPackageProcess(project, packageType, file2, new Predicate<Project>(){

            public boolean accept(Project project) {
                try {
                    return (Boolean)callable.call();
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
        });
    }

    private static Project assembleProject(ReadableConfiguration readableConfiguration, File file) {
        Project project = new Project(file, null);
        project.setConfiguration((Configuration)readableConfiguration);
        return project;
    }
}

