/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.impl.model.WorkflowStep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Workflow {
    private final List<WorkflowStep> fSteps;
    private final Map<String, WorkflowStep> fStepsByKey;

    public Workflow(List<WorkflowStep> list) {
        this.fSteps = new ArrayList<WorkflowStep>(list);
        this.fStepsByKey = new HashMap<String, WorkflowStep>();
        for (WorkflowStep workflowStep : this.getFlattenedSteps()) {
            this.fStepsByKey.put(workflowStep.getKey(), workflowStep);
        }
    }

    public WorkflowStep getStepByKey(String string) {
        return this.fStepsByKey.get(string);
    }

    public List<WorkflowStep> getSteps() {
        return new ArrayList<WorkflowStep>(this.fSteps);
    }

    public List<WorkflowStep> getFlattenedSteps() {
        ArrayList<WorkflowStep> arrayList = new ArrayList<WorkflowStep>();
        Workflow.flatten(arrayList, this.getSteps());
        return arrayList;
    }

    private static void flatten(List<WorkflowStep> list, List<WorkflowStep> list2) {
        for (WorkflowStep workflowStep : list2) {
            list.add(workflowStep);
            Workflow.flatten(list, workflowStep.getSubSteps());
        }
    }
}

