/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.plaf;

import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.mwswing.ColorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import sun.swing.DefaultLookup;

public class LightweightComboBoxUI
extends BasicComboBoxUI {
    @Override
    protected JButton createArrowButton() {
        JButton jButton = new JButton();
        jButton.setName("ComboBox.arrowButton");
        jButton.setIcon(DocumentIcon.BLACK_DOWN_ARROW.getIcon());
        jButton.setBorder(null);
        jButton.setOpaque(true);
        jButton.setUI(new ArrowButtonUI());
        return jButton;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.comboBox.setBorder(BorderFactory.createLineBorder(ColorUtils.convertToCurrentColorScheme((Color)new Color(215, 215, 215), (Color)UIManager.getColor("control"))));
    }

    @Override
    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        component.setBackground(UIManager.getColor("ComboBox.background"));
        component.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledForeground", null));
            component.setBackground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledBackground", null));
        }
        boolean bl2 = component instanceof JPanel;
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl2);
    }

    private static class ArrowButtonUI
    extends BasicButtonUI {
        private ArrowButtonUI() {
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            graphics = graphics.create();
            AbstractButton abstractButton = (AbstractButton)jComponent;
            ButtonModel buttonModel = abstractButton.getModel();
            Rectangle rectangle = new Rectangle(jComponent.getWidth() / 2 - abstractButton.getIcon().getIconWidth() / 2, jComponent.getHeight() / 2 - abstractButton.getIcon().getIconHeight() / 2, abstractButton.getIcon().getIconWidth(), abstractButton.getIcon().getIconHeight());
            graphics.setColor(UIManager.getColor("ComboBox.background"));
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            this.paintIcon(graphics, jComponent, rectangle);
            graphics.dispose();
        }

        @Override
        protected int getTextShiftOffset() {
            return 0;
        }
    }
}

