/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.plugin;

import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.XslInput;
import com.mathworks.project.impl.plugin.DefaultXpathEvaluator;
import com.mathworks.project.impl.plugin.SimpleExpression;
import com.mathworks.util.Log;
import java.io.IOException;

public final class ExpressionBasedTargetAttribute
implements DynamicTargetAttribute {
    private final String fString;
    private final SimpleExpression fExpression;
    private final DefaultXpathEvaluator fXpathEvaluator;
    private final String fRootTag;

    public ExpressionBasedTargetAttribute(String string, String string2) {
        this.fString = string;
        this.fXpathEvaluator = new DefaultXpathEvaluator("configuration");
        this.fExpression = SimpleExpression.compile(string, this.fXpathEvaluator);
        this.fRootTag = string2;
    }

    public boolean isAlwaysBooleanValue(boolean bl) {
        return bl ? this.fString.equals("true") : this.fString.equals("false");
    }

    @Override
    public XmlReader evaluate(XslInput xslInput) {
        try {
            String string = this.evaluateString(xslInput);
            XmlWriter xmlWriter = XmlApi.getInstance().create(this.fRootTag);
            xmlWriter.writeText((Object)string);
            return XmlApi.getInstance().read(xmlWriter.getXML());
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
            return null;
        }
    }

    @Override
    public boolean evaluateBoolean(XslInput xslInput) {
        return Boolean.parseBoolean(this.evaluateString(xslInput).trim());
    }

    @Override
    public String evaluateString(XslInput xslInput) {
        return this.fExpression.evaluate(this.fXpathEvaluator, xslInput.getDocument());
    }

    @Override
    public boolean hasReference(String string) {
        return this.fString.contains(string);
    }

    public String toString() {
        return this.fString;
    }
}

