/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.plugin;

import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.mlwidgets.explorer.model.ExplorerExtensionRegistry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.util.ReturnRunnable;
import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class LazyIcon
implements Icon {
    private final ReturnRunnable<Icon> fLoader;
    private Icon fIcon;

    public LazyIcon(ReturnRunnable<Icon> returnRunnable) {
        this.fLoader = returnRunnable;
    }

    public LazyIcon(final String string) {
        this(new ReturnRunnable<Icon>(){

            public Icon run() {
                return new ImageIcon(string);
            }
        });
    }

    public static LazyIcon forFile(final File file) {
        return new LazyIcon(new ReturnRunnable<Icon>(){

            public Icon run() {
                return UiFileSystemUtils.getIconEvenIfNonExistent((FileSystem)RealFileSystem.getInstance(), (FileLocation)new FileLocation(file), (ExtensionRegistry)ExplorerExtensionRegistry.getInstance());
            }
        });
    }

    private synchronized Icon getIcon() {
        if (this.fIcon == null) {
            this.fIcon = (Icon)this.fLoader.run();
        }
        return this.fIcon;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.getIcon().paintIcon(component, graphics, n, n2);
    }

    @Override
    public int getIconWidth() {
        return this.getIcon().getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.getIcon().getIconHeight();
    }
}

