/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.mwswing.ComponentUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.impl.model.FileSetFilter;
import com.mathworks.project.impl.settingsui.BrowseUtils;
import com.mathworks.project.impl.settingsui.ListTextFieldStyle;
import com.mathworks.project.impl.settingsui.ParamValuePopup;
import com.mathworks.project.impl.settingsui.SettingsTabbedPane;
import com.mathworks.project.impl.settingsui.TextFieldWithValidation;
import com.mathworks.project.impl.settingsui.validation.BasicTextValidator;
import com.mathworks.project.impl.settingsui.validation.ListRule;
import com.mathworks.project.impl.settingsui.validation.ValidationRule;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ReturnRunnable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class ListTextField {
    private final TextFieldWithValidation fFieldWithValidation;
    private final MJTextField fTextField;
    private final ListTextFieldStyle fStyle;
    private final MJPanel fComponent;
    private final ParamValuePopup fPopup;
    private final List<FileSetFilter> fFilters;
    private final Border fOriginalBorder;
    private final String fNamePrefix;
    private final MJButton fPopupButton;
    private final boolean fSettingsTableStyle;
    private final MulticastChangeListener fPopupStateListeners;
    private ValidationRule fElementRule;
    private ChangeListener fTabListener;
    private SettingsTabbedPane fTabbedPane;
    private MJTable fCurrentPopupTable;
    private ListEditorModel fCurrentPopupModel;

    public ListTextField(String string, ListTextFieldStyle listTextFieldStyle, boolean bl) {
        this(string, listTextFieldStyle, bl, new ArrayList<FileSetFilter>());
    }

    public ListTextField(String string, ListTextFieldStyle listTextFieldStyle, boolean bl, List<FileSetFilter> list) {
        this.fStyle = listTextFieldStyle;
        this.fPopupStateListeners = new MulticastChangeListener();
        this.fNamePrefix = string;
        this.fFilters = new ArrayList<FileSetFilter>(list);
        this.fFieldWithValidation = new TextFieldWithValidation();
        this.fTextField = this.fFieldWithValidation.getTextField();
        this.fTextField.setColumns(20);
        this.fTextField.setName(string + ".field");
        this.fOriginalBorder = this.fTextField.getBorder();
        this.fSettingsTableStyle = bl;
        this.fPopup = new ParamValuePopup(string);
        this.fPopup.setParentCallback(new ReturnRunnable<Window>(){

            public Window run() {
                return SwingUtilities.windowForComponent((Component)ListTextField.this.fComponent);
            }
        });
        this.fPopup.setContentCallback(new ReturnRunnable<Component>(){

            public Component run() {
                return ListTextField.this.createPopupTable();
            }
        });
        this.fPopup.setAnchorCallback(new ReturnRunnable<Point>(){

            public Point run() {
                Point point = ListTextField.this.fTextField.getLocation();
                SwingUtilities.convertPointToScreen(point, ListTextField.this.fTextField.getParent());
                return new Point((int)point.getX(), (int)(point.getY() + (double)ListTextField.this.fTextField.getHeight()));
            }
        });
        this.fPopup.setWidthCallback(new ReturnRunnable<Integer>(){

            public Integer run() {
                return ListTextField.this.fComponent.getWidth();
            }
        });
        this.fPopup.setCommitCallback(new Runnable(){

            @Override
            public void run() {
                if (ListTextField.this.fCurrentPopupTable.isEditing()) {
                    ListTextField.this.fCurrentPopupTable.getCellEditor().stopCellEditing();
                }
                ListTextField.this.fTextField.setText(ListTextField.this.fCurrentPopupModel.toString());
                ListTextField.this.fTextField.requestFocus();
            }
        });
        this.fPopup.setCancelCallback(new Runnable(){

            @Override
            public void run() {
                ListTextField.this.fTextField.requestFocus();
            }
        });
        this.fPopup.setHideCallback(new Runnable(){

            @Override
            public void run() {
                ListTextField.this.fPopupButton.setEnabled(true);
                ListTextField.this.restoreOriginalBorder();
                ListTextField.this.fPopupStateListeners.stateChanged(new ChangeEvent(this));
            }
        });
        this.fPopup.setPreShowCallback(new ParameterRunnable<JComponent>(){

            public void run(JComponent jComponent) {
                if (!PlatformInfo.isMacintosh()) {
                    LineBorder lineBorder = new LineBorder(MJUtilities.isHighContrast() ? Color.WHITE : Color.BLACK, 2);
                    ListTextField.this.fTextField.setBorder((Border)lineBorder);
                    jComponent.setBorder(lineBorder);
                }
            }
        });
        this.fTabListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!ListTextField.this.isClosedOrOnActiveTab()) {
                    ListTextField.this.fPopup.close();
                }
            }
        };
        this.fComponent = new MJPanel(new GridBagLayout()){

            public void addNotify() {
                super.addNotify();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object object;
                        for (object = ListTextField.this.fComponent; object != null && !(object instanceof SettingsTabbedPane); object = object.getParent()) {
                        }
                        if (object != null) {
                            ListTextField.this.fTabbedPane = (SettingsTabbedPane)object;
                            ListTextField.this.fTabbedPane.addTabChangeListener(ListTextField.this.fTabListener);
                        }
                    }
                });
            }

            public void requestFocus() {
                ListTextField.this.fTextField.requestFocus();
            }
        };
        this.fComponent.setOpaque(false);
        this.fPopupButton = new PopupButton(false, this.fSettingsTableStyle);
        this.fPopupButton.setName(string + ".button");
        this.fPopupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListTextField.this.fPopupButton.setEnabled(false);
                ListTextField.this.fPopup.show();
                ListTextField.this.fPopupStateListeners.stateChanged(new ChangeEvent(this));
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        if (!this.fSettingsTableStyle) {
            n = PlatformInfo.isMacintosh() ? 1 : 3;
        }
        gridBagConstraints.insets = new Insets(0, 0, 0, n);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.fComponent.add((Component)this.fTextField, (Object)gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.fComponent.add((Component)this.fPopupButton, (Object)gridBagConstraints);
    }

    public JTextField getTextField() {
        return this.fTextField;
    }

    public void dispose() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ListTextField.this.fTabbedPane != null) {
                    ListTextField.this.fTabbedPane.removeTabChangeListener(ListTextField.this.fTabListener);
                    ListTextField.this.fTabbedPane = null;
                }
                ListTextField.this.fPopup.close();
            }
        });
    }

    private boolean isClosedOrOnActiveTab() {
        return !this.fPopup.isShowing() || this.fTabbedPane == null || this.fTabbedPane.getSelectedComponent() != null && ComponentUtils.isChild((Component)this.fComponent, (Component)this.fTabbedPane.getSelectedComponent());
    }

    public void setToolTipText(String string) {
        this.fTextField.setToolTipText(string);
    }

    public void setFont(Font font) {
        this.fTextField.setFont(font);
    }

    public String getToolTipText() {
        return this.fTextField.getToolTipText();
    }

    public boolean showValidationMessage(ValidationMessage validationMessage) {
        this.fFieldWithValidation.setValidationMessage(validationMessage);
        return true;
    }

    public void clearValidationMessage() {
        this.fFieldWithValidation.clearValidationMessage();
    }

    public void setEnabled(boolean bl) {
        this.fTextField.setEnabled(bl);
        this.fPopupButton.setEnabled(bl);
    }

    public void setStringList(List<String> list) {
        this.fPopup.close();
        this.fTextField.setText(StringUtils.listToDelimitedString(list));
    }

    public void setFileList(List<File> list) {
        this.fPopup.close();
        this.fTextField.setText(StringUtils.listToDelimitedString(list));
    }

    public List<String> getStringList() {
        return StringUtils.delimitedStringToList(this.fTextField.getText());
    }

    public List<File> getFileList() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : StringUtils.delimitedStringToList(this.fTextField.getText())) {
            arrayList.add(new File(string));
        }
        return arrayList;
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.fTextField.getDocument().addDocumentListener(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.fTextField.getDocument().removeDocumentListener(documentListener);
    }

    public void addPopupStateListener(ChangeListener changeListener) {
        this.fPopupStateListeners.addChangeListener(changeListener);
    }

    public void removePopupStateListener(ChangeListener changeListener) {
        this.fPopupStateListeners.removeChangeListener(changeListener);
    }

    public Component getComponent() {
        return this.fComponent;
    }

    private void restoreOriginalBorder() {
        if (!PlatformInfo.isMacintosh()) {
            this.fTextField.setBorder(this.fOriginalBorder);
        }
    }

    public boolean isPopupShowing() {
        return this.fPopup.isShowing();
    }

    public void installBasicTextValidator(ValidationRule validationRule) {
        this.fElementRule = validationRule;
        new BasicTextValidator((JTextComponent)this.fTextField, new ListRule(validationRule, ";"));
    }

    private Component createPopupTable() {
        this.fCurrentPopupTable = new MJTable(){

            public Dimension getPreferredSize() {
                return new Dimension(ListTextField.this.fComponent.getWidth(), (int)super.getPreferredSize().getHeight());
            }

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension((int)super.getPreferredScrollableViewportSize().getWidth(), this.getRowHeight() * 10 + 4);
            }
        };
        this.fCurrentPopupTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)false);
        this.fCurrentPopupTable.setName(this.fNamePrefix + ".table");
        this.fCurrentPopupTable.setTableHeader(null);
        this.fCurrentPopupModel = new ListEditorModel(this.fTextField.getText());
        this.fCurrentPopupTable.setModel((TableModel)this.fCurrentPopupModel);
        this.fCurrentPopupTable.setDefaultEditor(String.class, (TableCellEditor)new PopupCellEditor());
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fCurrentPopupTable);
        mJScrollPane.setName(this.fNamePrefix + ".scroller");
        return mJScrollPane;
    }

    private void browseForFilesOrFolders(final JTable jTable, final int n, final JTextComponent jTextComponent) {
        if (this.fStyle == ListTextFieldStyle.FILES) {
            File file = new File((String)jTable.getValueAt(n, 0));
            File[] fileArray = BrowseUtils.browseFile((Component)this.fComponent, true, file, this.fFilters);
            if (fileArray != null && fileArray.length > 0) {
                jTable.setValueAt(fileArray[0].toString(), n, 0);
                jTextComponent.setText(fileArray[0].toString());
                int n2 = n + 1;
                for (int i = 1; i < fileArray.length; ++i) {
                    while (jTable.getValueAt(n2, 0).toString().trim().length() > 0) {
                        ++n2;
                    }
                    jTable.setValueAt(fileArray[i].toString(), n2, 0);
                }
            }
        } else if (this.fStyle == ListTextFieldStyle.DIRECTORIES) {
            File file = new File((String)jTable.getValueAt(n, 0));
            BrowseUtils.browseFolder((Component)this.fComponent, file, new ParameterRunnable<File>(){

                public void run(File file) {
                    jTextComponent.setText(file.toString());
                    jTable.setValueAt(file.toString(), n, 0);
                }
            });
        } else {
            throw new IllegalStateException(this.fStyle.toString());
        }
    }

    private static class ListEditorModel
    implements TableModel {
        private final List<String> fData;
        private final List<TableModelListener> fListeners = new ArrayList<TableModelListener>();
        private int fRealTokenCount;

        ListEditorModel(String string) {
            this.fData = StringUtils.delimitedStringToList(string);
            this.fRealTokenCount = this.fData.size();
            this.addExtraRows(false);
        }

        @Override
        public int getRowCount() {
            return this.fData.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int n) {
            return "";
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.fData.get(n);
        }

        private void addExtraRows(boolean bl) {
            while (this.fData.size() < 10) {
                this.fData.add("");
                if (!bl) continue;
                this.fireAddForLastRow();
            }
            if (this.fData.size() == this.fRealTokenCount) {
                if (bl) {
                    this.fireAddForLastRow();
                }
                this.fData.add("");
            }
        }

        private void fireAddForLastRow() {
            for (TableModelListener tableModelListener : this.fListeners) {
                tableModelListener.tableChanged(new TableModelEvent(this, this.fData.size() - 1));
            }
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (!((String)object).trim().equals(this.fData.get(n))) {
                this.fData.set(n, (String)object);
                for (TableModelListener tableModelListener : this.fListeners) {
                    tableModelListener.tableChanged(new TableModelEvent(this, n));
                }
                if (n > this.fRealTokenCount - 1) {
                    this.fRealTokenCount = n + 1;
                }
                this.addExtraRows(true);
            }
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
            this.fListeners.add(tableModelListener);
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.fListeners.remove(tableModelListener);
        }

        public String toString() {
            return StringUtils.listToDelimitedString(this.fData);
        }
    }

    private class PopupCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final Component fEditorComponent;
        private final MJTextField fEditorTextField = new MJTextField();
        private JTable fTable;
        private int fRow;
        private BasicTextValidator fValidator;

        PopupCellEditor() {
            this.fEditorTextField.setName(ListTextField.this.fNamePrefix + ".celleditor");
            this.fEditorTextField.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 2));
            if (ListTextField.this.fElementRule != null) {
                this.fValidator = new BasicTextValidator((JTextComponent)this.fEditorTextField, ListTextField.this.fElementRule);
                this.fValidator.setMessageAllowed(false);
            }
            if (ListTextField.this.fStyle == ListTextFieldStyle.STRINGS) {
                this.fEditorComponent = this.fEditorTextField;
            } else {
                PopupButton popupButton = new PopupButton(true, false);
                this.fEditorTextField.setName(ListTextField.this.fNamePrefix + ".celleditor.button");
                MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
                mJPanel.setBackground(this.fEditorTextField.getBackground());
                mJPanel.add((Component)this.fEditorTextField, (Object)"Center");
                mJPanel.add((Component)((Object)popupButton), (Object)"East");
                popupButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ListTextField.this.browseForFilesOrFolders(PopupCellEditor.this.fTable, PopupCellEditor.this.fRow, (JTextComponent)PopupCellEditor.this.fEditorTextField);
                    }
                });
                this.fEditorComponent = mJPanel;
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.fTable = jTable;
            this.fRow = n;
            if (this.fValidator != null) {
                this.fValidator.reset();
            }
            this.fEditorTextField.setText(object.toString());
            return this.fEditorComponent;
        }

        @Override
        public Object getCellEditorValue() {
            return this.fEditorTextField.getText();
        }
    }

    private static class PopupButton
    extends MJButton {
        private final boolean fSmall;

        PopupButton(boolean bl, boolean bl2) {
            super("...");
            this.fSmall = bl;
            if (PlatformInfo.isMacintosh() && !this.fSmall && !bl2) {
                this.putClientProperty("JButton.buttonType", "gradient");
            }
        }

        public Dimension getMinimumSize() {
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            Dimension dimension = super.getMinimumSize();
            if (graphics2D == null) {
                return dimension;
            }
            Rectangle2D rectangle2D = this.getFont().getStringBounds(this.getText(), graphics2D.getFontRenderContext());
            return new Dimension((int)(rectangle2D.getWidth() * (this.fSmall ? 1.5 : 2.0)), (int)dimension.getHeight());
        }

        public Dimension getPreferredSize() {
            if (PlatformInfo.isMacintosh() && !this.fSmall) {
                return super.getPreferredSize();
            }
            return this.getMinimumSize();
        }
    }
}

