/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJHelpButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.DynamicTargetAttribute;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamSet;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.settingsui.NavigationBar;
import com.mathworks.project.impl.settingsui.ParamSetPanel;
import com.mathworks.project.impl.settingsui.SettingsTabbedPane;
import com.mathworks.project.impl.settingsui.table.NameColumn;
import com.mathworks.project.impl.settingsui.table.SettingsTableUtils;
import com.mathworks.project.impl.settingsui.table.ValueColumn;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.util.Converter;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.SearchTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class NewSettingsDialog {
    private final MJFrame fFrame;
    private final Project fProject;
    private final List<ParamSetPanel> fPanels;
    private final JPanel fButtons;
    private final Configuration fConfiguration;
    private final MainArea fMainArea;
    private final MJButton fHelpButton;
    private final Map<Component, ParamSet> fComponentParamSets;
    private final NavigationBar fNavigationBar;
    private final PropertyChangeListener fPropertyChangeListener;
    private final MulticastChangeListener fChangeListeners;
    private final ProjectComponent fExtraPanel;
    private final List<Runnable> fCloseCallbacks;
    private final Set<String> fSuppressedParamSets;
    private final SearchTextField fSearchTextField;
    private MJPanel fTablePanel;
    private PropertyTable<Param> fAllSettingsTable;
    private int fMaxPreferredWidth;
    private int fMaxPreferredHeight;
    private Component fSelectedComponent;
    private ParamSet fCurrentParamSet;
    private boolean fDisposed;
    private static Map<Project, NewSettingsDialog> sOpenDialogs = new HashMap<Project, NewSettingsDialog>();
    private static final Color MAC_BACKGROUND_COLOR = new Color(237, 237, 237);

    public static NewSettingsDialog invoke() {
        return NewSettingsDialog.invoke(ProjectGUI.getInstance().getCurrentProject());
    }

    public static NewSettingsDialog invoke(Project project) {
        NewSettingsDialog newSettingsDialog = sOpenDialogs.get(project);
        if (newSettingsDialog == null) {
            newSettingsDialog = new NewSettingsDialog(project, null, null);
            sOpenDialogs.put(project, newSettingsDialog);
        }
        newSettingsDialog.show();
        return newSettingsDialog;
    }

    public static NewSettingsDialog invokeTemporaryProject(Project project, String[] stringArray, String string, final String string2, final Object ... objectArray) {
        NewSettingsDialog newSettingsDialog = sOpenDialogs.get(project);
        if (newSettingsDialog == null) {
            DynamicTargetAttribute dynamicTargetAttribute;
            ProjectComponent projectComponent = null;
            if (string != null && string.length() > 0) {
                try {
                    projectComponent = (ProjectComponent)Class.forName(string).getConstructor(Configuration.class).newInstance(project.getConfiguration());
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
            newSettingsDialog = new NewSettingsDialog(project, projectComponent, stringArray);
            if (string2 != null) {
                newSettingsDialog.addCloseCallback(new Runnable(){

                    @Override
                    public void run() {
                        new Matlab().fevalConsoleOutput(string2, objectArray);
                    }
                });
            }
            if ((dynamicTargetAttribute = project.getConfiguration().getTarget().getProjectWindowTitle()) != null) {
                String string3 = project.getConfiguration().getProjectWindowTitle();
                newSettingsDialog.fFrame.setTitle(string3);
            }
        }
        newSettingsDialog.show();
        return newSettingsDialog;
    }

    private NewSettingsDialog(Project project, ProjectComponent projectComponent, String[] stringArray) {
        this.fProject = project;
        this.fExtraPanel = projectComponent;
        this.fPanels = new ArrayList<ParamSetPanel>();
        this.fChangeListeners = new MulticastChangeListener();
        this.fMainArea = new MainArea();
        this.fCloseCallbacks = new LinkedList<Runnable>();
        this.fSuppressedParamSets = new HashSet<String>();
        if (stringArray != null) {
            this.fSuppressedParamSets.addAll(Arrays.asList(stringArray));
        }
        if (PlatformInfo.isMacintosh()) {
            this.fMainArea.setBackground(MAC_BACKGROUND_COLOR);
            this.fMainArea.setOpaque(true);
        }
        this.fComponentParamSets = new HashMap<Component, ParamSet>();
        this.fPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("@settings-dialog-height") || propertyChangeEvent.getPropertyName().equals("@settings-dialog-width")) {
                    NewSettingsDialog.this.autoResizeDialog();
                } else if (Configuration.isParamSetVisibilityChange(propertyChangeEvent)) {
                    NewSettingsDialog.this.rebuildNavigationBar();
                }
            }
        };
        this.fFrame = new MJFrame();
        this.fFrame.setName("settings.dialog");
        this.fFrame.setTitle(BuiltInResources.getString("projectsettings.title"));
        this.fFrame.getRootPane().putClientProperty("apple.awt.brushMetalLook", Boolean.TRUE);
        this.fConfiguration = project.getConfiguration();
        this.fNavigationBar = new NavigationBar(new ParameterRunnable<Component>(){

            public void run(Component component) {
                if (NewSettingsDialog.this.fAllSettingsTable != null) {
                    NewSettingsDialog.this.fAllSettingsTable.stopEditing(PlatformInfo.isMacintosh());
                }
                NewSettingsDialog.this.select(component);
            }
        });
        this.fSearchTextField = new SearchTextField("");
        this.fSearchTextField.getComponent().setName("settings.search.field");
        this.fSearchTextField.setPromptText(BuiltInResources.getString("settings.search.prompt"));
        this.rebuildNavigationBar();
        this.fSearchTextField.addSearchTextFieldListener(new SearchTextField.Listener(){

            public void search(String string) {
            }

            public void searchTextChanged(String string) {
                NewSettingsDialog.this.fAllSettingsTable.stopEditing(PlatformInfo.isMacintosh());
                NewSettingsDialog.this.fAllSettingsTable.setSearchText(string);
                NewSettingsDialog.this.fAllSettingsTable.getComponent().revalidate();
                NewSettingsDialog.this.fAllSettingsTable.getComponent().repaint();
            }

            public void searchCleared() {
            }
        });
        MJButton mJButton = new MJButton(BuiltInResources.getString("button.close"));
        mJButton.setName("settings.close");
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewSettingsDialog.this.fAllSettingsTable.stopEditing(false);
                NewSettingsDialog.this.close();
            }
        });
        this.fHelpButton = new MJHelpButton();
        this.fHelpButton.setName("settings.help");
        this.fHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Target target = NewSettingsDialog.this.fConfiguration.getTarget();
                String string = PluginManager.resolveHelpMapPath(target.getHelpMapPath());
                String string2 = null;
                if (NewSettingsDialog.this.fCurrentParamSet != null) {
                    string2 = NewSettingsDialog.this.fConfiguration.evaluateString(NewSettingsDialog.this.fCurrentParamSet.getHelpTopicKey());
                }
                if (string2 == null && target.getSettingsHelpKeyGeneratorClassName() != null) {
                    try {
                        Class<?> clazz = Class.forName(target.getSettingsHelpKeyGeneratorClassName());
                        Constructor<?> constructor = clazz.getConstructor(Configuration.class);
                        Converter converter = (Converter)constructor.newInstance(NewSettingsDialog.this.fConfiguration);
                        string2 = (String)converter.convert((Object)NewSettingsDialog.this.fCurrentParamSet);
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException(exception);
                    }
                }
                MLHelpServices.cshDisplayTopic((Object)NewSettingsDialog.this.fFrame, (String)string, string2);
            }
        });
        if (PlatformInfo.isMacintosh()) {
            this.fHelpButton.putClientProperty((Object)"JButton.buttonType", (Object)"help");
            this.fButtons = new MJPanel((LayoutManager)new FlowLayout(2, 8, 8));
            this.fButtons.setBackground(MAC_BACKGROUND_COLOR);
            this.fButtons.setOpaque(true);
            this.fButtons.add((Component)this.fHelpButton);
        } else {
            this.fButtons = ButtonBarFactory.buildCloseHelpBar((JButton)mJButton, (JButton)this.fHelpButton);
        }
        if (PlatformInfo.isMacintosh()) {
            this.fFrame.add((Component)this.fNavigationBar.getComponent(), (Object)"North");
            this.fFrame.add(NewSettingsDialog.integrateExtraPanel((Component)((Object)this.fMainArea), projectComponent), (Object)"Center");
            this.fFrame.add((Component)this.fButtons, (Object)"South");
        } else {
            CellConstraints cellConstraints = new CellConstraints();
            this.fFrame.setLayout((LayoutManager)new FormLayout("3dlu, fill:d:grow, 3dlu", "fill:p, fill:d:grow, 3dlu, fill:d, 3dlu"));
            this.fFrame.add((Component)this.fNavigationBar.getComponent(), (Object)cellConstraints.xyw(1, 1, 3));
            this.fFrame.add(NewSettingsDialog.integrateExtraPanel((Component)((Object)this.fMainArea), projectComponent), (Object)cellConstraints.xyw(1, 2, 3));
            this.fFrame.add((Component)this.fButtons, (Object)cellConstraints.xy(2, 4));
        }
        this.fFrame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NewSettingsDialog.this.fDisposed = true;
                sOpenDialogs.remove(NewSettingsDialog.this.fProject);
                for (Object object : NewSettingsDialog.this.fPanels) {
                    ((ParamSetPanel)object).dispose();
                }
                if (NewSettingsDialog.this.fExtraPanel != null) {
                    NewSettingsDialog.this.fExtraPanel.dispose();
                }
                NewSettingsDialog.this.fNavigationBar.dispose();
                NewSettingsDialog.this.fConfiguration.removePropertyChangeListener(NewSettingsDialog.this.fPropertyChangeListener);
                NewSettingsDialog.this.fAllSettingsTable.dispose();
                for (Object object : NewSettingsDialog.this.fCloseCallbacks) {
                    object.run();
                }
                NewSettingsDialog.this.fCloseCallbacks.clear();
                Component component = NewSettingsDialog.this.fFrame.getFocusOwner();
                if (component != null && component instanceof JFormattedTextField && component.getParent() != null && component.getParent() instanceof JSpinner.DefaultEditor) {
                    try {
                        ((JSpinner.DefaultEditor)component.getParent()).commitEdit();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (!NewSettingsDialog.this.fDisposed) {
                    this.windowClosing(windowEvent);
                }
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                NewSettingsDialog.this.fFrame.repaint();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                NewSettingsDialog.this.fFrame.repaint();
            }
        });
        this.fConfiguration.addPropertyChangeListener(this.fPropertyChangeListener);
        this.autoResizeDialog();
        this.fFrame.setLocationRelativeTo((Component)MatlabDesktopServices.getDesktop().getMainFrame());
        this.fFrame.setVisible(true);
    }

    public void close() {
        this.fFrame.dispose();
    }

    public static void close(Project project) {
        NewSettingsDialog newSettingsDialog = sOpenDialogs.get(project);
        if (newSettingsDialog != null) {
            newSettingsDialog.close();
            sOpenDialogs.remove(project);
        }
    }

    public void show() {
        this.fFrame.show();
    }

    private static Component integrateExtraPanel(Component component, ProjectComponent projectComponent) {
        if (projectComponent == null) {
            return component;
        }
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        if (PlatformInfo.isMacintosh()) {
            mJPanel.setBackground(MAC_BACKGROUND_COLOR);
            mJPanel.setOpaque(true);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        mJPanel.add(component, (Object)gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        MJPanel mJPanel2 = new MJPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(1, 1);
            }
        };
        mJPanel2.setBackground(PlatformInfo.isMacintosh() ? Color.BLACK : Color.GRAY);
        mJPanel2.setOpaque(true);
        ++gridBagConstraints.gridy;
        mJPanel.add((Component)mJPanel2, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 9;
        mJPanel.add(projectComponent.getComponent(), (Object)gridBagConstraints);
        return mJPanel;
    }

    private void select(Component component) {
        Component component2 = this.fSelectedComponent;
        this.fCurrentParamSet = this.fComponentParamSets.get(component);
        this.fSelectedComponent = component;
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
        if (component2 != null) {
            this.fMainArea.remove(component2);
        }
        this.fMainArea.add(this.fSelectedComponent, "Center");
        this.fMainArea.revalidate();
        this.fMainArea.repaint();
    }

    private void autoResizeDialog() {
        Dimension dimension = this.fNavigationBar.getComponent().getPreferredSize();
        int n = (int)Math.max((double)(this.fMaxPreferredWidth + (PlatformInfo.isLinux() ? 16 : 10)), Math.max((double)this.fConfiguration.getSettingsDialogWidth(), dimension.getWidth()));
        int n2 = (int)Math.max((double)this.fConfiguration.getSettingsDialogHeight(), dimension.getHeight() + (double)this.fMaxPreferredHeight + this.fButtons.getPreferredSize().getHeight() + 22.0);
        if (this.fExtraPanel != null) {
            n2 = (int)((double)n2 + (this.fExtraPanel.getComponent().getPreferredSize().getHeight() + (double)(PlatformInfo.isMacintosh() ? 5 : 20)));
        }
        this.fFrame.setSize(new Dimension(n, n2));
        this.fFrame.setMinimumSize(this.fFrame.getSize());
    }

    public void addCloseCallback(Runnable runnable) {
        this.fCloseCallbacks.add(runnable);
    }

    private List<ParamSet> rebuildNavigationBar() {
        Object object;
        this.fNavigationBar.reset();
        for (ParamSetPanel object32 : this.fPanels) {
            object32.dispose();
        }
        this.fPanels.clear();
        ArrayList arrayList = new ArrayList();
        for (ParamSet paramSet : this.fConfiguration.getTarget().getParamSets()) {
            if (this.fSuppressedParamSets.contains(paramSet.getKey()) || !this.fConfiguration.isParamSetVisible(paramSet.getKey())) continue;
            arrayList.add(paramSet);
            if (paramSet.getIcon() == null) continue;
            object = new ParamSetPanel(this.fProject, paramSet, false, false);
            this.fPanels.add((ParamSetPanel)object);
            Component component = ((ParamSetPanel)object).getComponent();
            Dimension dimension = component.getPreferredSize();
            this.fMaxPreferredWidth = (int)Math.max((double)this.fMaxPreferredWidth, dimension.getWidth());
            this.fMaxPreferredHeight = (int)Math.max((double)this.fMaxPreferredHeight, dimension.getHeight());
            this.fComponentParamSets.put(component, paramSet);
            this.fNavigationBar.addElement(paramSet.getName(), paramSet.getIcon(), component);
        }
        NameColumn nameColumn = new NameColumn();
        ValueColumn valueColumn = new ValueColumn(this.fConfiguration);
        object = new CellConstraints();
        this.fAllSettingsTable = SettingsTableUtils.createTable(this.fProject, arrayList, Arrays.asList(nameColumn, valueColumn));
        this.fAllSettingsTable.getComponent().setName("settings.table");
        this.fTablePanel = new MJPanel((LayoutManager)new FormLayout("3dlu, fill:d:grow, 3dlu", "3dlu, fill:d, 3dlu, fill:d:grow"));
        this.fTablePanel.setOpaque(false);
        this.fTablePanel.add((Component)this.fAllSettingsTable.getComponent(), (Object)object.xyw(1, 4, 3));
        this.fTablePanel.add((Component)this.fSearchTextField.getComponent(), (Object)object.xy(2, 2));
        this.fNavigationBar.addElement(BuiltInResources.getString("settings.all"), new ImageIcon(this.getClass().getResource("/com/mathworks/project/impl/resources/gear.png")), (Component)this.fTablePanel);
        return arrayList;
    }

    private class MainArea
    extends MJPanel
    implements SettingsTabbedPane {
        MainArea() {
            super((LayoutManager)new BorderLayout());
        }

        @Override
        public Component getSelectedComponent() {
            return NewSettingsDialog.this.fSelectedComponent;
        }

        @Override
        public void addTabChangeListener(ChangeListener changeListener) {
            NewSettingsDialog.this.fChangeListeners.addChangeListener(changeListener);
        }

        @Override
        public void removeTabChangeListener(ChangeListener changeListener) {
            NewSettingsDialog.this.fChangeListeners.removeChangeListener(changeListener);
        }
    }
}

